/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view;

import java.text.DateFormat;
import nextapp.echo2.app.Component;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.LookupNameHelper;
import org.openvpms.web.component.im.view.AbstractReadOnlyComponentFactory;
import org.openvpms.web.component.im.view.layout.ViewLayoutStrategyFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.factory.ComponentFactory;
import org.openvpms.web.echo.factory.TextComponentFactory;
import org.openvpms.web.echo.text.TextComponent;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;

public class ReadOnlyComponentFactory
extends AbstractReadOnlyComponentFactory {
    public static final int MAX_DISPLAY_LENGTH = 50;

    public ReadOnlyComponentFactory(LayoutContext context) {
        this(context, "default");
    }

    public ReadOnlyComponentFactory(LayoutContext context, String style) {
        super(context, ServiceHelper.getBean(ViewLayoutStrategyFactory.class), style);
    }

    public static TextComponent getText(String text, int minLength, int maxLength, String style) {
        if (text != null && !text.isEmpty()) {
            minLength = text.length();
        } else if (minLength > 20) {
            minLength = 20;
        }
        TextComponent result = TextComponentFactory.create((String)text, (int)minLength, (int)maxLength);
        ComponentFactory.setStyle((Component)result, (String)style);
        result.setEnabled(false);
        return result;
    }

    @Override
    protected Component createLookup(Property property, IMObject context) {
        String value = LookupNameHelper.getName(context, property.getName());
        TextComponent result = ReadOnlyComponentFactory.getText(value, property.getMaxLength(), 50, this.getStyle());
        return result;
    }

    @Override
    protected Component createDate(Property property) {
        DateFormat format = DateFormatter.getDateFormat((boolean)false);
        int maxColumns = DateFormatter.getLength((DateFormat)format);
        TextField result = BoundTextComponentFactory.create(property, maxColumns, format);
        ComponentFactory.setStyle((Component)result, (String)this.getStyle());
        return result;
    }
}

