/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view;

import echopointng.GroupBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Insets;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.filter.ChainedNodeFilter;
import org.openvpms.web.component.im.filter.FilterHelper;
import org.openvpms.web.component.im.filter.NamedNodeFilter;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.layout.LayoutHelper;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.view.DefaultIMObjectComponent;
import org.openvpms.web.component.im.view.IMObjectCollectionViewer;
import org.openvpms.web.component.im.view.IMObjectComponent;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.component.im.view.ReadOnlyComponentFactory;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GroupBoxFactory;
import org.openvpms.web.echo.table.SortableTableModel;

public abstract class IMTableCollectionViewer<T>
implements IMObjectCollectionViewer {
    protected static final int ROWS = 15;
    private final IMObject object;
    private final CollectionProperty property;
    private final LayoutContext context;
    private PagedIMTable<T> table;
    private Component component;
    private GroupBox box;

    public IMTableCollectionViewer(CollectionProperty property, IMObject parent, LayoutContext layout) {
        this.context = new DefaultLayoutContext(layout);
        this.context.setComponentFactory(new TableComponentFactory(this.context));
        NamedNodeFilter idFilter = new NamedNodeFilter("id");
        ChainedNodeFilter filter = FilterHelper.chain(idFilter, this.context.getDefaultNodeFilter());
        this.context.setNodeFilter(filter);
        this.object = parent;
        this.property = property;
    }

    @Override
    public CollectionProperty getProperty() {
        return this.property;
    }

    public IMObject getObject() {
        return this.object;
    }

    @Override
    public Component getComponent() {
        if (this.component == null) {
            this.component = this.doLayout();
        }
        return this.component;
    }

    protected abstract IMTableModel<T> createTableModel(LayoutContext var1);

    protected abstract void setSelected(IMObject var1);

    protected abstract ResultSet<T> createResultSet();

    protected Component doLayout() {
        IMObjectCollectionComponent column = new IMObjectCollectionComponent();
        column.setStyleName("CellSpacing");
        column.add(this.getTable().getComponent());
        this.populateTable();
        return column;
    }

    protected LayoutContext getLayoutContext() {
        return this.context;
    }

    protected void onBrowse() {
        IMObject object = this.getSelected();
        if (object != null) {
            this.browse(object);
        }
    }

    protected void browse(IMObject object) {
        if (this.box == null) {
            this.box = GroupBoxFactory.create();
            this.box.setInsets(new Insets(0));
        } else {
            this.box.removeAll();
        }
        this.component.add((Component)this.box);
        DefaultLayoutContext viewContext = new DefaultLayoutContext(this.context);
        viewContext.setComponentFactory(new ReadOnlyComponentFactory(viewContext));
        IMObjectViewer viewer = this.createViewer(object, viewContext);
        this.box.setTitle(viewer.getTitle());
        Component child = viewer.getComponent();
        if (LayoutHelper.needsInset(child)) {
            child = ColumnFactory.create((String)"Inset", (Component[])new Component[]{child});
        }
        this.box.add(child);
    }

    protected List<IMObject> getObjects() {
        List<?> values = this.property.getValues();
        ArrayList<IMObject> objects = new ArrayList<IMObject>();
        for (Object value : values) {
            objects.add((IMObject)value);
        }
        return objects;
    }

    protected PagedIMTable<T> getTable() {
        if (this.table == null) {
            this.table = this.createTable();
        }
        return this.table;
    }

    protected PagedIMTable<T> createTable() {
        IMTableModel<T> tableModel = this.createTableModel(this.getLayoutContext());
        PagedIMTable<T> table = new PagedIMTable<T>(tableModel);
        table.getTable().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent e) {
                IMTableCollectionViewer.this.onBrowse();
            }
        });
        return table;
    }

    protected void populateTable() {
        SortableTableModel sortable;
        ResultSet<T> set = this.createResultSet();
        this.table.setResultSet(set);
        IMTableModel<T> model = this.table.getTable().getModel();
        if (model instanceof SortableTableModel && (sortable = (SortableTableModel)model).getSortColumn() == -1 && model.getDefaultSortColumn() != -1) {
            sortable.sort(model.getDefaultSortColumn(), model.getDefaultSortAscending());
        }
    }

    protected IMObjectViewer createViewer(IMObject object, LayoutContext context) {
        return new IMObjectViewer(object, this.getObject(), context);
    }

    private class IMObjectCollectionComponent
    extends Column
    implements IMObjectComponent {
        private IMObjectCollectionComponent() {
        }

        @Override
        public IMObject getObject() {
            return null;
        }

        @Override
        public String getNode() {
            return IMTableCollectionViewer.this.getProperty().getName();
        }

        @Override
        public IMObjectComponent getSelected() {
            IMObject object = IMTableCollectionViewer.this.getSelected();
            return object != null ? new DefaultIMObjectComponent(object, (Component)IMTableCollectionViewer.this.box) : null;
        }

        @Override
        public boolean select(Selection selection) {
            boolean result = false;
            IMObject object = selection.getObject();
            IMTableCollectionViewer.this.setSelected(object);
            if (object != null && Objects.equals(object, IMTableCollectionViewer.this.getSelected())) {
                IMTableCollectionViewer.this.onBrowse();
                result = true;
            }
            return result;
        }

        @Override
        public Component getComponent() {
            return IMTableCollectionViewer.this.box;
        }
    }
}

