/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.focus.FocusHelper;

public class ComponentState {
    private final Component component;
    private final Property property;
    private final FocusGroup focusGroup;
    private String displayName;
    private Label label;

    public ComponentState(Component component) {
        this(component, null, null);
    }

    public ComponentState(Component component, FocusGroup focusGroup) {
        this(component, null, focusGroup);
    }

    public ComponentState(Component component, Property property) {
        this(component, property, null);
    }

    public ComponentState(Component component, Property property, FocusGroup focusGroup) {
        this(component, property, focusGroup, null);
    }

    public ComponentState(PropertyEditor editor) {
        this(editor.getComponent(), editor.getProperty(), editor.getFocusGroup(), editor.getProperty().getDisplayName());
    }

    public ComponentState(Component component, Property property, FocusGroup focusGroup, String displayName) {
        this.component = component;
        this.property = property;
        this.focusGroup = focusGroup;
        this.displayName = displayName != null ? displayName : (property != null ? property.getDisplayName() : null);
    }

    public Component getComponent() {
        return this.component;
    }

    public Property getProperty() {
        return this.property;
    }

    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    public boolean hasLabel() {
        return this.label != null || !StringUtils.isEmpty((CharSequence)this.displayName);
    }

    public Label getLabel() {
        if (this.label == null) {
            this.label = LabelFactory.create();
            this.label.setText(this.displayName);
        }
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setVisible(boolean visible) {
        this.getLabel().setVisible(visible);
        this.component.setVisible(visible);
    }

    public Component getFocusable() {
        Component result = this.focusGroup != null ? this.focusGroup.getFocusable() : FocusHelper.getFocusable((Component)this.component);
        return result;
    }
}

