/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.ActionListener;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.IMObjectComponent;
import org.openvpms.web.component.im.view.IMObjectView;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.component.im.view.SelectionHelper;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;

public abstract class AbstractIMObjectView
implements IMObjectView {
    private final IMObject object;
    private final IMObject parent;
    private final PropertySet properties;
    private IMObjectLayoutStrategy layout;
    private Component component;
    private FocusGroup focusGroup;
    private ActionListener layoutListener;

    public AbstractIMObjectView(IMObject object, PropertySet properties, IMObject parent, IMObjectLayoutStrategy layout) {
        this.object = object;
        this.parent = parent;
        this.properties = properties;
        this.layout = layout;
    }

    @Override
    public IMObject getObject() {
        return this.object;
    }

    @Override
    public Component getComponent() {
        if (this.component == null) {
            this.component = this.createComponent();
            if (this.layoutListener != null) {
                this.layoutListener.actionPerformed(new ActionEvent((Object)this, null));
            }
        }
        return this.component;
    }

    @Override
    public boolean hasComponent() {
        return this.component != null;
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    @Override
    public void setLayout(IMObjectLayoutStrategy layout) {
        this.component = null;
        this.layout = layout;
        this.getComponent();
    }

    @Override
    public IMObjectLayoutStrategy getLayout() {
        return this.layout;
    }

    @Override
    public void setLayoutListener(ActionListener listener) {
        this.layoutListener = listener;
    }

    @Override
    public List<Selection> getSelectionPath() {
        if (this.component != null) {
            return SelectionHelper.getSelectionPath(this.component);
        }
        return Collections.emptyList();
    }

    @Override
    public void setSelectionPath(List<Selection> path) {
        Iterator<Selection> iterator = path.iterator();
        for (IMObjectComponent current = this.component != null ? SelectionHelper.getComponent(this.component) : null; current != null && iterator.hasNext() && current.select(iterator.next()); current = current.getSelected()) {
        }
    }

    @Override
    public HelpContext getHelpContext() {
        return this.getLayoutContext().getHelpContext();
    }

    protected Component createComponent() {
        LayoutContext context = this.getLayoutContext();
        ComponentState component = this.layout.apply(this.object, this.properties, this.parent, context);
        this.focusGroup = component.getFocusGroup();
        return component.getComponent();
    }

    protected abstract LayoutContext getLayoutContext();
}

