/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.util;

import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.cache.IMObjectCache;
import org.openvpms.web.component.im.util.IMObjectHelper;

public class IMObjectNames {
    private final Map<Reference, String> names;
    private final IMObjectCache cache;
    private final IArchetypeService service;

    public IMObjectNames(IMObjectCache cache, IArchetypeService service, int cacheSize) {
        this.names = new LRUMap(cacheSize);
        this.cache = cache;
        this.service = service;
    }

    public String getName(Reference reference) {
        IMObject object;
        String name = this.names.get(reference);
        if (name == null && (name = (object = this.cache.getCached(reference)) != null ? object.getName() : IMObjectHelper.getName(reference, this.service)) != null) {
            this.names.put(reference, name);
        }
        return name;
    }

    public void clear() {
        this.names.clear();
    }
}

