/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.till;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.till.CashDrawer;
import org.openvpms.web.component.im.till.CashDrawerFactory;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.print.BoundPrinterField;
import org.openvpms.web.component.print.PrintHelper;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class TillEditor
extends AbstractIMObjectEditor {
    public TillEditor(IMObject object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new LayoutStrategy();
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateDrawerCommand(validator);
    }

    private boolean validateDrawerCommand(Validator validator) {
        boolean valid = true;
        Property property = this.getProperty("drawerCommand");
        String command = property.getString();
        if (!StringUtils.isEmpty((CharSequence)command)) {
            String[] values;
            for (String value : values = command.split(",")) {
                if (this.validateControlCode(validator, property, value)) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    private boolean validateControlCode(Validator validator, Property property, String code) {
        boolean valid = false;
        try {
            int value = Integer.parseInt(code.trim());
            if (value >= 0 && value < 256) {
                valid = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!valid) {
            validator.add((Modifiable)property, new ValidatorError(property, Messages.get((String)"till.opendrawer.invalidcommand")));
        }
        return valid;
    }

    private void onTest() {
        DefaultValidator validator = new DefaultValidator();
        if (!this.validate(validator)) {
            ValidationHelper.showError(validator);
        } else {
            Entity till = (Entity)this.getObject();
            CashDrawer drawer = ServiceHelper.getBean(CashDrawerFactory.class).create(till);
            try {
                if (drawer.canOpen()) {
                    InformationDialog dialog = new InformationDialog(Messages.get((String)"till.opendrawer"));
                    dialog.setStyleName("InformationDialog.Compact");
                    dialog.show(1);
                    try {
                        drawer.open();
                    }
                    catch (Exception exception) {
                        dialog.close();
                        ErrorHelper.show(exception);
                    }
                } else {
                    InformationDialog.show((String)Messages.get((String)"till.opendrawer.unsupported"));
                }
            }
            catch (Exception exception) {
                ErrorHelper.show(exception);
            }
        }
    }

    private class LayoutStrategy
    extends AbstractLayoutStrategy {
        private LayoutStrategy() {
        }

        @Override
        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            Property printerName = properties.get("printerName");
            BoundPrinterField field = new BoundPrinterField(printerName, PrintHelper.getPrinters());
            this.addComponent(new ComponentState((Component)field, printerName));
            Property drawerCommand = properties.get("drawerCommand");
            ComponentState drawer = this.createComponent(drawerCommand, parent, context);
            Button button = ButtonFactory.create((String)"button.test", () -> TillEditor.this.onTest());
            Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{drawer.getComponent(), button});
            ComponentState state = new ComponentState((Component)row, drawerCommand);
            this.addComponent(state);
            return super.apply(object, properties, parent, context);
        }
    }
}

