/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.till;

import org.openvpms.archetype.rules.finance.till.TillRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.till.Till;
import org.openvpms.tilldrawer.service.TillDrawerService;
import org.openvpms.web.component.im.till.CashDrawer;

public class CashDrawerFactory {
    private final TillDrawerService drawerService;
    private final TillRules rules;
    private final ArchetypeService service;
    private final DomainService domainService;

    public CashDrawerFactory(TillDrawerService drawerService, TillRules rules, ArchetypeService service, DomainService domainService) {
        this.drawerService = drawerService;
        this.rules = rules;
        this.service = service;
        this.domainService = domainService;
    }

    public CashDrawer create(Entity till) {
        return new CashDrawer((Till)this.domainService.create((IMObject)till, Till.class), this.drawerService, this.rules);
    }

    public CashDrawer create(Act act) {
        CashDrawer result = null;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        if (bean.hasNode("till")) {
            Entity till = (Entity)bean.getTarget("till", Entity.class);
            result = till != null ? this.create(till) : null;
        }
        return result;
    }
}

