/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.table;

import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.table.AbstractIMTableModel;

public class NameDescObjectSetTableModel
extends AbstractIMTableModel<ObjectSet> {
    protected static final int ID_INDEX = 0;
    protected static final int ARCHETYPE_INDEX = 1;
    protected static final int NAME_INDEX = 2;
    protected static final int DESCRIPTION_INDEX = 3;
    protected static final int ACTIVE_INDEX = 4;
    private final String reference;
    private final String name;
    private final String description;
    private final String active;
    private boolean showArchetype;
    private boolean showActive;

    public NameDescObjectSetTableModel() {
        this(null, false, false);
    }

    public NameDescObjectSetTableModel(String alias, boolean showArchetype, boolean showActive) {
        this.showArchetype = showArchetype;
        this.setTableColumnModel(this.createTableColumnModel(showArchetype, showActive));
        if (alias != null) {
            this.reference = alias + ".reference";
            this.name = alias + ".name";
            this.description = alias + ".description";
            this.active = alias + ".active";
        } else {
            this.reference = "reference";
            this.name = "name";
            this.description = "description";
            this.active = "active";
        }
    }

    public void showArchetype(boolean show) {
        if (show != this.showArchetype) {
            this.showArchetype = show;
            this.setTableColumnModel(this.createTableColumnModel(this.showArchetype, this.showActive));
        }
    }

    public void setShowActive(boolean show) {
        if (show != this.showActive) {
            this.showActive = show;
            this.setTableColumnModel(this.createTableColumnModel(this.showArchetype, this.showActive));
        }
    }

    @Override
    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        SortConstraint[] sortConstraintArray;
        NodeSortConstraint result = null;
        if (column == 0) {
            result = new NodeSortConstraint("id", ascending);
        } else if (column == 2) {
            result = new NodeSortConstraint("name", ascending);
        } else if (column == 3) {
            result = new NodeSortConstraint("description", ascending);
        } else if (column == 4) {
            result = new NodeSortConstraint("active", ascending);
        }
        if (result != null) {
            SortConstraint[] sortConstraintArray2 = new SortConstraint[1];
            sortConstraintArray = sortConstraintArray2;
            sortConstraintArray2[0] = result;
        } else {
            sortConstraintArray = null;
        }
        return sortConstraintArray;
    }

    @Override
    protected Object getValue(ObjectSet set, TableColumn column, int row) {
        Object result = null;
        int index = column.getModelIndex();
        switch (index) {
            case 0: {
                result = set.getReference(this.reference).getId();
                break;
            }
            case 1: {
                IMObjectReference ref = set.getReference(this.reference);
                result = this.getDisplayName(ref.getArchetype());
                break;
            }
            case 2: {
                result = set.getString(this.name);
                break;
            }
            case 3: {
                result = set.getString(this.description);
                break;
            }
            case 4: {
                result = this.getCheckBox(set.getBoolean(this.active));
            }
        }
        return result;
    }

    protected TableColumnModel createTableColumnModel(boolean showArchetype, boolean showActive) {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        model.addColumn(NameDescObjectSetTableModel.createTableColumn(0, "table.imobject.id"));
        if (showArchetype) {
            model.addColumn(NameDescObjectSetTableModel.createTableColumn(1, "table.imobject.archetype"));
        }
        model.addColumn(NameDescObjectSetTableModel.createTableColumn(2, "table.imobject.name"));
        model.addColumn(NameDescObjectSetTableModel.createTableColumn(3, "table.imobject.description"));
        if (showActive) {
            model.addColumn(NameDescObjectSetTableModel.createTableColumn(4, "table.imobject.active"));
        }
        return model;
    }
}

