/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.table;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.table.AbstractMarkablePagedIMTableModel;
import org.openvpms.web.component.im.table.IMObjectTableModel;
import org.openvpms.web.component.im.util.IMObjectHelper;

public class MarkablePagedIMObjectTableModel<T extends IMObject>
extends AbstractMarkablePagedIMTableModel<T> {
    private final Set<Reference> marked = new LinkedHashSet<Reference>();

    public MarkablePagedIMObjectTableModel(IMObjectTableModel<T> model) {
        super(model);
    }

    public List<T> getMarked() {
        ArrayList<IMObject> result = new ArrayList<IMObject>();
        for (Reference reference : this.marked) {
            IMObject object = IMObjectHelper.getObject(reference);
            if (object == null) continue;
            result.add(object);
        }
        return result;
    }

    @Override
    public boolean isMarked() {
        return !this.marked.isEmpty();
    }

    @Override
    protected void mark(T object, boolean mark) {
        if (mark) {
            this.marked.add(object.getObjectReference());
        } else {
            this.marked.remove(object.getObjectReference());
        }
    }

    @Override
    protected boolean isMarked(T object) {
        return this.marked.contains(object.getObjectReference());
    }

    @Override
    protected void clearMarks() {
        this.marked.clear();
    }
}

