/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.ListMarkModel;
import org.openvpms.web.component.im.table.PagedIMTableModel;

public abstract class AbstractMarkablePagedIMTableModel<T>
extends PagedIMTableModel<T, T> {
    private final ListMarkModel.Listener listener;

    public AbstractMarkablePagedIMTableModel(IMTableModel<T> model) {
        super(model);
        ListMarkModel rowMarks = model.getRowMarkModel();
        if (rowMarks != null) {
            this.listener = new ListMarkModel.Listener(){

                @Override
                public void changed(int index, boolean marked) {
                    AbstractMarkablePagedIMTableModel.this.setMarked(index, marked);
                }

                @Override
                public void cleared() {
                    AbstractMarkablePagedIMTableModel.this.clearMarks();
                }
            };
            rowMarks.addListener(this.listener);
        } else {
            this.listener = null;
        }
    }

    public void setMarked(T object, boolean mark) {
        ListMarkModel rowMarks;
        this.mark(object, mark);
        int index = this.getObjects().indexOf(object);
        if (index != -1 && (rowMarks = this.getModel().getRowMarkModel()) != null) {
            rowMarks.removeListener(this.listener);
            rowMarks.setMarked(index, mark);
            rowMarks.addListener(this.listener);
        }
    }

    public abstract boolean isMarked();

    public List<T> getMarked(Collection<T> objects) {
        ArrayList<T> result = new ArrayList<T>();
        for (T object : objects) {
            if (!this.isMarked(object)) continue;
            result.add(object);
        }
        return result;
    }

    public void unmarkAll() {
        ListMarkModel rowMarks = this.getModel().getRowMarkModel();
        if (rowMarks != null) {
            rowMarks.removeListener(this.listener);
            rowMarks.clear();
            this.clearMarks();
            rowMarks.addListener(this.listener);
        }
    }

    protected abstract void mark(T var1, boolean var2);

    protected abstract boolean isMarked(T var1);

    protected abstract void clearMarks();

    @Override
    protected void setPage(List<T> objects) {
        ListMarkModel rowMarks = this.getModel().getRowMarkModel();
        if (rowMarks != null) {
            rowMarks.removeListener(this.listener);
        }
        super.setPage(objects);
        if (rowMarks != null) {
            int i = 0;
            for (T object : objects) {
                if (this.isMarked(object)) {
                    rowMarks.setMarked(i, true);
                }
                ++i;
            }
            rowMarks.addListener(this.listener);
        }
    }

    protected void setMarked(int row, boolean mark) {
        Object object = this.getObjects().get(row);
        this.mark(object, mark);
    }
}

