/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.table;

import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import org.openvpms.component.business.domain.im.common.EntityIdentity;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.table.AbstractIMTableModel;

public abstract class AbstractEntityObjectSetTableModel
extends AbstractIMTableModel<ObjectSet> {
    public static final int ID_INDEX = 0;
    public static final int NAME_INDEX = 1;
    public static final int DESCRIPTION_INDEX = 2;
    public static final int IDENTITY_INDEX = 3;
    public static final int ACTIVE_INDEX = 4;
    protected static final int NEXT_INDEX = 5;
    protected static final String IDENTITY = "table.entity.identity";
    private final String entityKey;
    private final String identityKey;

    public AbstractEntityObjectSetTableModel(String entityKey, String identityKey) {
        this.entityKey = entityKey;
        this.identityKey = identityKey;
    }

    @Override
    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        NodeSortConstraint[] result = null;
        if (column == 0) {
            result = new NodeSortConstraint[]{new NodeSortConstraint(this.entityKey, "id", ascending)};
        } else if (column == 1) {
            result = new NodeSortConstraint[]{new NodeSortConstraint(this.entityKey, "name", ascending)};
        } else if (column == 2) {
            result = new NodeSortConstraint[]{new NodeSortConstraint(this.entityKey, "description", ascending), new NodeSortConstraint(this.entityKey, "name", true)};
        } else if (column == 4) {
            result = new NodeSortConstraint[]{new NodeSortConstraint(this.entityKey, "active", ascending), new NodeSortConstraint(this.entityKey, "name", true)};
        }
        return result;
    }

    @Override
    protected Object getValue(ObjectSet set, TableColumn column, int row) {
        Object result = null;
        int index = column.getModelIndex();
        switch (index) {
            case 0: {
                result = this.getId(set);
                break;
            }
            case 1: {
                result = this.getName(set);
                break;
            }
            case 2: {
                result = this.getDescription(set);
                break;
            }
            case 3: {
                result = this.getIdentity(set);
                break;
            }
            case 4: {
                result = this.getActive(set);
            }
        }
        return result;
    }

    protected Entity getEntity(ObjectSet set) {
        return (Entity)set.get(this.entityKey);
    }

    protected Long getId(ObjectSet set) {
        Entity entity = this.getEntity(set);
        return entity != null ? Long.valueOf(entity.getId()) : null;
    }

    protected String getName(ObjectSet set) {
        Entity entity = this.getEntity(set);
        return entity != null ? entity.getName() : null;
    }

    protected String getDescription(ObjectSet set) {
        Entity entity = this.getEntity(set);
        return entity != null ? entity.getDescription() : null;
    }

    protected String getIdentity(ObjectSet set) {
        EntityIdentity identity = (EntityIdentity)set.get(this.identityKey);
        return identity != null ? identity.getName() : null;
    }

    protected CheckBox getActive(ObjectSet set) {
        Entity entity = this.getEntity(set);
        return entity != null ? this.getActive((IMObject)entity) : null;
    }

    protected static DefaultTableColumnModel createTableColumnModel(boolean showIdentity, boolean showActive) {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        model.addColumn(AbstractEntityObjectSetTableModel.createTableColumn(0, "table.imobject.id"));
        model.addColumn(AbstractEntityObjectSetTableModel.createTableColumn(1, "table.imobject.name"));
        model.addColumn(AbstractEntityObjectSetTableModel.createTableColumn(2, "table.imobject.description"));
        if (showIdentity) {
            model.addColumn(AbstractEntityObjectSetTableModel.createTableColumn(3, IDENTITY));
        }
        if (showActive) {
            model.addColumn(AbstractEntityObjectSetTableModel.createTableColumn(4, "table.imobject.active"));
        }
        return model;
    }
}

