/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.sms;

import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.sms.service.SMSService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ReloadingContext;
import org.openvpms.web.component.im.sms.SMSEditor;
import org.openvpms.web.component.macro.MacroDialog;
import org.openvpms.web.component.macro.MacroVariables;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class SMSDialog
extends ModalDialog {
    private final SMSEditor editor;
    private final Column container;

    public SMSDialog(Contact phone, Context context, HelpContext help) {
        this(phone != null ? Collections.singletonList(phone) : null, context, help);
    }

    public SMSDialog(List<Contact> phones, final Context context, HelpContext help) {
        super(Messages.get((String)"sms.send.title"), OK_CANCEL, help);
        MacroVariables variables = new MacroVariables(new ReloadingContext(context), (ArchetypeService)ServiceHelper.getArchetypeService(), ServiceHelper.getLookupService());
        SMSService smsService = ServiceHelper.getSMSService();
        this.editor = this.createEditor(phones, variables, context, smsService);
        this.editor.setMaxParts(smsService.getMaxParts());
        this.container = ColumnFactory.create((String)"WideCellSpacing");
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{this.container}));
        this.getFocusGroup().add(0, this.editor.getFocusGroup());
        this.getButtons().addKeyListener(4173, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                SMSDialog.this.onMacro(context);
            }
        });
        this.editor.getFocusGroup().setFocus();
        this.resize("SMSDialog.size");
    }

    public void setMessage(String message) {
        this.editor.setMessage(message);
    }

    protected SMSEditor createEditor(List<Contact> phones, MacroVariables variables, Context context, SMSService smsService) {
        return new SMSEditor(phones, (Variables)variables, context, smsService);
    }

    protected void onOK() {
        if (this.send()) {
            super.onOK();
        }
    }

    protected void onMacro(Context context) {
        MacroDialog dialog = new MacroDialog(context, this.getHelpContext());
        dialog.show();
    }

    protected boolean send() {
        boolean result = false;
        try {
            DefaultValidator validator = new DefaultValidator();
            if (this.editor.validate(validator)) {
                this.editor.send();
                result = true;
            } else {
                ValidationHelper.showError(validator);
            }
        }
        catch (Throwable exception) {
            ErrorHelper.show(exception);
        }
        return result;
    }

    protected SMSEditor getEditor() {
        return this.editor;
    }

    protected Column getContainer() {
        return this.container;
    }

    protected void doLayout() {
        this.container.add(this.editor.getComponent());
    }
}

