/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.report;

import java.util.function.Supplier;
import org.apache.commons.lang3.time.StopWatch;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.report.Report;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportRunner {
    private final Report report;
    private final Object object;
    private static final Logger log = LoggerFactory.getLogger(ReportRunner.class);

    public ReportRunner(Report report) {
        this(report, null);
    }

    public ReportRunner(Report report, Object object) {
        this.report = report;
        this.object = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document run(Supplier<Document> generator) {
        Document result;
        StopWatch stopWatch = this.init();
        try {
            result = generator.get();
        }
        finally {
            if (stopWatch != null) {
                this.complete(stopWatch);
            }
        }
        return result;
    }

    public void run(Runnable generator) {
        StopWatch stopWatch = this.init();
        try {
            generator.run();
        }
        finally {
            if (stopWatch != null) {
                this.complete(stopWatch);
            }
        }
    }

    private StopWatch init() {
        StopWatch stopWatch = null;
        if (log.isDebugEnabled()) {
            stopWatch = new StopWatch();
            stopWatch.start();
            String value = this.object instanceof IMObject ? ((IMObject)this.object).getObjectReference().toString() : (this.object != null ? this.object.toString() : "collection");
            log.debug("Running report='" + this.report.getName() + "', for " + value);
        }
        return stopWatch;
    }

    private void complete(StopWatch stopWatch) {
        log.debug("Finished report='" + this.report.getName() + "', elapsed=" + stopWatch);
    }
}

