/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.apache.commons.collections.Transformer;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.util.VirtualNodeSortConstraint;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;

public class RelationshipStateTableModel
extends AbstractIMTableModel<RelationshipState> {
    protected static final int NAME_INDEX = 1;
    protected static final int DESCRIPTION_INDEX = 2;
    protected static final int DETAIL_INDEX = 3;
    protected static final int ACTIVE_INDEX = 4;
    private final boolean displayTarget;
    private final ContextSwitchListener listener;
    private final LayoutContext context;
    private boolean showActive;

    public RelationshipStateTableModel(LayoutContext context, boolean displayTarget) {
        this.context = context;
        this.displayTarget = displayTarget;
        this.setTableColumnModel(this.createTableColumnModel());
        this.listener = context.getContextSwitchListener();
    }

    public void setShowActive(boolean show) {
        if (show != this.showActive) {
            this.showActive = show;
            this.setTableColumnModel(this.createTableColumnModel());
        }
    }

    public boolean getShowActive() {
        return this.showActive;
    }

    @Override
    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        SortConstraint[] result = null;
        TableColumn col = this.getColumn(column);
        if (col.getModelIndex() == 1) {
            result = new SortConstraint[]{this.getNameSortConstraint(ascending)};
        } else if (col.getModelIndex() == 2) {
            VirtualNodeSortConstraint sort = new VirtualNodeSortConstraint("description", ascending, input -> {
                RelationshipState state = (RelationshipState)input;
                return this.displayTarget ? state.getTargetDescription() : state.getSourceDescription();
            });
            result = new SortConstraint[]{sort, this.getNameSortConstraint(true)};
        } else if (col.getModelIndex() == 3) {
            VirtualNodeSortConstraint sort = new VirtualNodeSortConstraint("detail", ascending, input -> {
                RelationshipState state = (RelationshipState)input;
                return state.getRelationship().getDescription();
            });
            result = new SortConstraint[]{sort, this.getNameSortConstraint(true)};
        } else if (col.getModelIndex() == 4) {
            VirtualNodeSortConstraint sort = new VirtualNodeSortConstraint("active", ascending, new Transformer(){

                public Object transform(Object input) {
                    RelationshipState state = (RelationshipState)input;
                    return state.getRelationship().isActive();
                }
            });
            result = new SortConstraint[]{sort, this.getNameSortConstraint(true)};
        }
        return result;
    }

    protected SortConstraint getNameSortConstraint(boolean ascending) {
        VirtualNodeSortConstraint result = new VirtualNodeSortConstraint("name", ascending, new Transformer(){

            public Object transform(Object input) {
                RelationshipState state = (RelationshipState)input;
                return RelationshipStateTableModel.this.displayTarget ? state.getTargetName() : state.getSourceName();
            }
        });
        return result;
    }

    protected boolean displayTarget() {
        return this.displayTarget;
    }

    @Override
    protected Object getValue(RelationshipState object, TableColumn column, int row) {
        Object result = null;
        switch (column.getModelIndex()) {
            case 1: {
                result = this.getEntityViewer(object);
                break;
            }
            case 2: {
                result = this.getDescription(object);
                break;
            }
            case 3: {
                result = object.getRelationship().getDescription();
                break;
            }
            case 4: {
                result = this.getCheckBox(object.isActive());
            }
        }
        return result;
    }

    protected Component getEntityViewer(RelationshipState state) {
        String name;
        Reference ref;
        if (this.displayTarget) {
            ref = state.getTarget();
            name = state.getTargetName();
        } else {
            ref = state.getSource();
            name = state.getSourceName();
        }
        return this.getEntityViewer(ref, name);
    }

    protected Component getEntityViewer(Reference ref, String name) {
        ContextSwitchListener link = !this.getEnableSelection() ? this.listener : null;
        return new IMObjectReferenceViewer(ref, name, link, this.context.getContext()).getComponent();
    }

    protected Object getDescription(RelationshipState state) {
        return this.displayTarget ? state.getTargetDescription() : state.getSourceDescription();
    }

    protected TableColumnModel createTableColumnModel() {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        model.addColumn(RelationshipStateTableModel.createTableColumn(1, "table.imobject.name"));
        model.addColumn(RelationshipStateTableModel.createTableColumn(2, "table.imobject.description"));
        model.addColumn(RelationshipStateTableModel.createTableColumn(3, "table.entityrelationship.details"));
        if (this.showActive) {
            model.addColumn(RelationshipStateTableModel.createTableColumn(4, "table.imobject.active"));
        }
        return model;
    }

    protected LayoutContext getContext() {
        return this.context;
    }
}

