/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IdConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.component.im.relationship.RelationshipStateFactory;
import org.openvpms.web.system.ServiceHelper;

public class RelationshipStateQuery {
    private final IMObject parent;
    private final List<IMObject> relationships;
    private final String[] relationshipShortNames;
    private final boolean source;
    private final String[] shortNames;
    private final String primaryNode;
    private final String secondaryNode;
    private final String secondaryIdNode;
    private final String secondaryNameNode;
    private final String secondaryDescNode;
    private final String secondaryActiveNode;
    private final RelationshipStateFactory factory;
    private static final RelationshipStateFactory DEFAULT_FACTORY = new RelationshipStateFactory();

    public RelationshipStateQuery(IMObject parent, List<IMObject> relationships, String[] relationshipShortNames) {
        this(parent, relationships, relationshipShortNames, DEFAULT_FACTORY);
    }

    public RelationshipStateQuery(IMObject parent, List<IMObject> relationships, String[] relationshipShortNames, RelationshipStateFactory factory) {
        this.parent = parent;
        this.relationships = relationships;
        this.relationshipShortNames = relationshipShortNames;
        this.factory = factory;
        Reference ref = parent.getObjectReference();
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        String[] sourceShortNames = DescriptorHelper.getNodeShortNames((String[])relationshipShortNames, (String)"source", (ArchetypeService)service);
        String[] targetShortNames = null;
        boolean isSource = true;
        if (TypeHelper.isA((IMObject)parent, (String[])sourceShortNames)) {
            targetShortNames = DescriptorHelper.getNodeShortNames((String[])relationshipShortNames, (String)"target", (ArchetypeService)service);
            if (TypeHelper.isA((IMObject)parent, (String[])targetShortNames)) {
                for (IMObject object : relationships) {
                    Relationship relationship = (Relationship)object;
                    if (relationship.getSource() == null || relationship.getSource().equals((Object)ref)) continue;
                    isSource = false;
                    break;
                }
            }
        } else {
            isSource = false;
        }
        this.source = isSource;
        if (this.source) {
            this.primaryNode = "source";
            this.secondaryNode = "target";
            this.shortNames = targetShortNames;
        } else {
            this.primaryNode = "target";
            this.secondaryNode = "source";
            this.shortNames = sourceShortNames;
        }
        String alias = this.getSecondaryAlias();
        this.secondaryIdNode = alias + ".id";
        this.secondaryNameNode = alias + ".name";
        this.secondaryDescNode = alias + ".description";
        this.secondaryActiveNode = alias + ".active";
    }

    public IMObject getParent() {
        return this.parent;
    }

    public boolean parentIsSource() {
        return this.source;
    }

    public Map<Relationship, RelationshipState> query() {
        HashMap<Long, Relationship> relsById = new HashMap<Long, Relationship>();
        for (IMObject relationship : this.relationships) {
            relsById.put(relationship.getId(), (Relationship)relationship);
        }
        HashMap<Relationship, RelationshipState> result = new HashMap<Relationship, RelationshipState>();
        if (!relsById.isEmpty()) {
            IArchetypeQuery query = this.createQuery();
            query.setMaxResults(1000);
            ObjectSetQueryIterator iter = new ObjectSetQueryIterator(query);
            while (iter.hasNext()) {
                String targetDesc;
                String targetName;
                long targetId;
                String sourceDesc;
                String sourceName;
                long sourceId;
                ObjectSet set = (ObjectSet)iter.next();
                long relId = set.getLong("relationship.id");
                long id = set.getLong(this.secondaryIdNode);
                String name = set.getString(this.secondaryNameNode);
                String description = set.getString(this.secondaryDescNode);
                boolean active = set.getBoolean(this.secondaryActiveNode);
                Relationship r = (Relationship)relsById.remove(relId);
                if (r == null) continue;
                if (this.source) {
                    sourceId = this.parent.getId();
                    sourceName = this.parent.getName();
                    sourceDesc = this.parent.getDescription();
                    targetId = id;
                    targetName = name;
                    targetDesc = description;
                } else {
                    sourceId = id;
                    sourceName = name;
                    sourceDesc = description;
                    targetId = this.parent.getId();
                    targetName = this.parent.getName();
                    targetDesc = this.parent.getDescription();
                }
                RelationshipState state = this.factory.create(this.parent, r, sourceId, sourceName, sourceDesc, targetId, targetName, targetDesc, active, set);
                result.put(r, state);
            }
            for (Relationship r : relsById.values()) {
                result.put(r, this.factory.create(this.parent, r, this.source));
            }
        }
        return result;
    }

    public RelationshipStateFactory getFactory() {
        return this.factory;
    }

    protected IArchetypeQuery createQuery() {
        ShortNameConstraint relationships = new ShortNameConstraint("relationship", this.relationshipShortNames, false, false);
        ObjectRefConstraint primary = new ObjectRefConstraint(this.primaryNode, this.parent.getObjectReference());
        ShortNameConstraint secondary = new ShortNameConstraint(this.secondaryNode, this.shortNames, false, false);
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)relationships);
        query.setMaxResults(-1);
        query.add((IConstraint)primary);
        query.add((IConstraint)secondary);
        query.add((IConstraint)new IdConstraint("relationship.source", "source"));
        query.add((IConstraint)new IdConstraint("relationship.target", "target"));
        query.add((IConstraint)new NodeSelectConstraint("relationship.id"));
        query.add((IConstraint)new NodeSelectConstraint(this.secondaryIdNode));
        query.add((IConstraint)new NodeSelectConstraint(this.secondaryNameNode));
        query.add((IConstraint)new NodeSelectConstraint(this.secondaryDescNode));
        query.add((IConstraint)new NodeSelectConstraint(this.secondaryActiveNode));
        query.add((IConstraint)new NodeSortConstraint("relationship", "id"));
        return query;
    }

    protected String[] getShortNames() {
        return this.shortNames;
    }

    protected String getSecondaryAlias() {
        return this.secondaryNode;
    }

    protected String[] getRelationshipShortNames() {
        return this.relationshipShortNames;
    }
}

