/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import nextapp.echo2.app.Component;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategyFactory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.PropertySetBuilder;
import org.openvpms.web.echo.factory.LabelFactory;

public class RelationshipLayoutStrategy
implements IMObjectLayoutStrategy {
    private final boolean displayInine;

    public RelationshipLayoutStrategy() {
        this(false);
    }

    public RelationshipLayoutStrategy(boolean displayInline) {
        this.displayInine = displayInline;
    }

    @Override
    public void addComponent(ComponentState state) {
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        ComponentState result;
        Relationship relationship = (Relationship)object;
        Reference ref = this.getObject(relationship, parent);
        if (!this.displayInine) {
            IMObjectReferenceViewer viewer = new IMObjectReferenceViewer(ref, context.getContextSwitchListener(), context.getContext());
            result = new ComponentState(viewer.getComponent());
        } else {
            IMObject entity = context.getCache().get(ref);
            if (entity != null) {
                IMObjectLayoutStrategyFactory factory = context.getLayoutStrategyFactory();
                IMObjectLayoutStrategy strategy = factory.create(entity, object);
                result = strategy.apply(entity, new PropertySetBuilder(entity, context).build(), object, context);
            } else {
                result = new ComponentState((Component)LabelFactory.create());
            }
        }
        return result;
    }

    protected Reference getObject(Relationship relationship, IMObject parent) {
        Reference result;
        if (parent == null) {
            result = relationship.getTarget();
        } else {
            Reference ref = parent.getObjectReference();
            result = relationship.getSource() != null && ref.equals((Object)relationship.getSource()) ? relationship.getTarget() : (relationship.getTarget() != null && ref.equals((Object)relationship.getTarget()) ? relationship.getSource() : relationship.getTarget());
        }
        return result;
    }
}

