/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.relationship.DelegatingRelationshipStateTableModel;
import org.openvpms.web.component.im.relationship.RelationshipDescriptorTableModel;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.component.im.relationship.RelationshipStateQuery;
import org.openvpms.web.component.im.relationship.RelationshipStateResultSet;
import org.openvpms.web.component.im.relationship.RelationshipStateTableModel;
import org.openvpms.web.component.im.table.IMObjectTableModel;
import org.openvpms.web.component.im.table.IMObjectTableModelFactory;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.view.IMTableCollectionViewer;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.resource.i18n.Messages;

public class RelationshipCollectionViewer
extends IMTableCollectionViewer<RelationshipState> {
    private final boolean parentIsSource;
    private final CheckBox hideInactive;
    private final Map<Relationship, RelationshipState> states;

    public RelationshipCollectionViewer(CollectionProperty property, IMObject parent, LayoutContext context) {
        this(property, parent, true, context);
    }

    public RelationshipCollectionViewer(CollectionProperty property, IMObject parent, boolean hideInactive, LayoutContext context) {
        super(property, parent, context);
        RelationshipStateQuery query = this.createQuery(parent);
        this.parentIsSource = query.parentIsSource();
        this.hideInactive = hideInactive ? CheckBoxFactory.create(null, (boolean)true) : null;
        this.states = query.query();
    }

    @Override
    public IMObject getSelected() {
        RelationshipState state = (RelationshipState)this.getTable().getTable().getSelected();
        return state != null ? state.getRelationship() : null;
    }

    @Override
    protected IMTableModel<RelationshipState> createTableModel(LayoutContext context) {
        String[] archetypes = this.getProperty().getArchetypeRange();
        if (IMObjectTableModelFactory.hasModel(archetypes, RelationshipDescriptorTableModel.class)) {
            IMObjectTableModel<Relationship> model = IMObjectTableModelFactory.create(archetypes, context);
            return new DelegatingRelationshipStateTableModel(model, context);
        }
        return new RelationshipStateTableModel(context, this.parentIsSource);
    }

    @Override
    protected void setSelected(IMObject object) {
        RelationshipState state = this.states.get(object);
        this.getTable().getTable().setSelected(state);
    }

    @Override
    protected ResultSet<RelationshipState> createResultSet() {
        List<RelationshipState> result = this.getRelationshipStates();
        return new RelationshipStateResultSet(result, 15);
    }

    protected List<RelationshipState> getRelationshipStates() {
        ArrayList<RelationshipState> result;
        if (this.hideInactive()) {
            result = new ArrayList();
            for (RelationshipState relationship : this.states.values()) {
                if (!relationship.isActive()) continue;
                result.add(relationship);
            }
        } else {
            result = new ArrayList<RelationshipState>(this.states.values());
        }
        return result;
    }

    protected RelationshipStateQuery createQuery(IMObject parent) {
        return new RelationshipStateQuery(parent, this.getObjects(), this.getProperty().getArchetypeRange());
    }

    protected boolean parentIsSource() {
        return this.parentIsSource;
    }

    @Override
    protected Component doLayout() {
        Component component = super.doLayout();
        if (this.hideInactive != null) {
            String name = this.getProperty().getDisplayName();
            String label = Messages.format((String)"relationship.hide.inactive", (Object[])new Object[]{name});
            this.hideInactive.setText(label);
            this.hideInactive.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    RelationshipCollectionViewer.this.onHideInactiveChanged();
                }
            });
            component.add((Component)this.hideInactive, 0);
        }
        return component;
    }

    protected boolean hideInactive() {
        return this.hideInactive != null && this.hideInactive.isSelected();
    }

    private void onHideInactiveChanged() {
        IMTableModel model = this.getTable().getModel().getModel();
        if (model instanceof RelationshipStateTableModel) {
            ((RelationshipStateTableModel)model).setShowActive(!this.hideInactive());
        }
        this.populateTable();
    }
}

