/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.component.im.table.DelegatingIMTableModel;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;

public class DelegatingRelationshipStateTableModel
extends DelegatingIMTableModel<RelationshipState, Relationship> {
    private final LayoutContext context;
    private List<RelationshipState> states;
    private int sourceColumn = -1;
    private int targetColumn = -1;

    public DelegatingRelationshipStateTableModel(IMTableModel<Relationship> model, LayoutContext context) {
        this.setModel(model);
        this.context = context;
    }

    @Override
    public Object getValueAt(int column, int row) {
        if (column == this.sourceColumn) {
            return this.getSource(row);
        }
        if (column == this.targetColumn) {
            return this.getTarget(row);
        }
        return super.getValueAt(column, row);
    }

    @Override
    public void setObjects(List<RelationshipState> objects) {
        this.states = objects;
        ArrayList<Relationship> list = new ArrayList<Relationship>(this.states.size());
        for (RelationshipState state : this.states) {
            list.add(state.getRelationship());
        }
        this.getModel().setObjects(list);
    }

    @Override
    public List<RelationshipState> getObjects() {
        return this.states;
    }

    @Override
    protected void setModel(IMTableModel<Relationship> model) {
        super.setModel(model);
        TableColumnModel columns = model.getColumnModel();
        this.sourceColumn = this.getModelIndex(columns, "source");
        this.targetColumn = this.getModelIndex(columns, "target");
    }

    private Component getSource(int row) {
        if (row < this.states.size()) {
            RelationshipState state = this.states.get(row);
            ContextSwitchListener listener = this.context.isEdit() ? this.context.getContextSwitchListener() : null;
            IMObjectReferenceViewer viewer = new IMObjectReferenceViewer(state.getSource(), state.getSourceName(), listener, this.context.getContext());
            return viewer.getComponent();
        }
        return null;
    }

    private Object getTarget(int row) {
        if (row < this.states.size()) {
            RelationshipState state = this.states.get(row);
            ContextSwitchListener listener = this.context.isEdit() ? this.context.getContextSwitchListener() : null;
            IMObjectReferenceViewer viewer = new IMObjectReferenceViewer(state.getTarget(), state.getTargetName(), listener, this.context.getContext());
            return viewer.getComponent();
        }
        return null;
    }

    private int getModelIndex(TableColumnModel model, String node) {
        Iterator iter = model.getColumns();
        while (iter.hasNext()) {
            DescriptorTableColumn col;
            TableColumn next = (TableColumn)iter.next();
            if (!(next instanceof DescriptorTableColumn) || !(col = (DescriptorTableColumn)next).getName().equals(node)) continue;
            return col.getModelIndex();
        }
        return -1;
    }
}

