/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.comparators.ComparatorChain;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.im.query.ArchetypeQueryResultSet;
import org.openvpms.web.component.im.query.ObjectSetQueryExecutor;
import org.openvpms.web.system.ServiceHelper;

public class PageLocator {
    public static final Comparator<Date> DATE_COMPARATOR = new Comparator<Date>(){

        @Override
        public int compare(Date o1, Date o2) {
            return DateRules.compareTo((Date)o1, (Date)o2);
        }
    };
    private final IMObjectBean bean;
    private final ArchetypeQuery query;
    private final int pageSize;
    private final ObjectSet keySet;
    private final NodeComparator<Long> ID = new NodeComparator("a.id", ComparatorUtils.naturalComparator());
    private final ComparatorChain<ObjectSet> comparators = new ComparatorChain();
    private boolean initialised;

    public PageLocator(IMObject object, ArchetypeQuery query, int pageSize) {
        this.bean = ServiceHelper.getArchetypeService().getBean(object);
        this.query = query;
        this.pageSize = pageSize;
        query.getArchetypeConstraint().setAlias("a");
        query.add((IConstraint)new NodeSelectConstraint("id"));
        this.keySet = new ObjectSet();
        this.keySet.set("a.id", (Object)object.getId());
    }

    public <T extends Comparable> void addKey(String node, boolean ascending, Comparator<T> comparator) {
        this.query.add((IConstraint)new NodeSelectConstraint(node));
        this.query.add((IConstraint)new NodeSortConstraint(node, ascending));
        if (!ascending) {
            comparator = ComparatorUtils.reversedComparator(comparator);
        }
        this.comparators.addComparator(new NodeComparator("a." + node, comparator));
        this.keySet.set("a." + node, this.bean.getValue(node));
    }

    public int getPage() {
        IPage page;
        int index;
        if (!this.initialised) {
            this.query.add((IConstraint)new NodeSortConstraint("id"));
            this.comparators.addComparator(this.ID);
            this.initialised = true;
        }
        int result = 0;
        ArchetypeQueryResultSet<ObjectSet> set = new ArchetypeQueryResultSet<ObjectSet>(this.query, this.pageSize, new ObjectSetQueryExecutor());
        while (set.hasNext() && (index = Collections.binarySearch((page = set.next()).getResults(), this.keySet, this.comparators)) < 0 && (index = -index - 1) >= page.getResults().size()) {
            ++result;
        }
        return result;
    }

    private static class NodeComparator<T>
    implements Comparator<ObjectSet> {
        private final String name;
        private final Comparator<T> comparator;

        public NodeComparator(String name, Comparator<T> comparator) {
            this.name = name;
            this.comparator = comparator;
        }

        @Override
        public int compare(ObjectSet o1, ObjectSet o2) {
            Object v1 = o1.get(this.name);
            Object v2 = o2.get(this.name);
            return this.comparator.compare(v1, v2);
        }
    }
}

