/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.query.EntityObjectSetQuery;
import org.openvpms.web.component.im.query.EntityObjectSetResultSet;
import org.openvpms.web.component.im.query.EntityResultSetAdapter;
import org.openvpms.web.component.im.query.QueryAdapter;
import org.openvpms.web.component.im.query.QueryException;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.util.IMObjectHelper;

public class EntityQuery<T extends Entity>
extends QueryAdapter<ObjectSet, T> {
    private final Context context;

    public EntityQuery(String[] shortNames, Context context) {
        this(new EntityObjectSetQuery(shortNames), context);
    }

    public EntityQuery(EntityObjectSetQuery query, Context context) {
        super(query, IMObjectHelper.getType(query.getShortNames()));
        this.context = context;
        if (!Entity.class.isAssignableFrom(this.getType())) {
            throw new QueryException(QueryException.ErrorCode.InvalidType, Entity.class, this.getType());
        }
    }

    public String getShortName() {
        return this.getQuery().getShortName();
    }

    public void setActiveOnly(boolean active) {
        this.getQuery().setActiveOnly(active);
    }

    @Override
    public boolean selects(T object) {
        return this.getQuery().selects((Entity)object);
    }

    public EntityObjectSetQuery getQuery() {
        return (EntityObjectSetQuery)super.getQuery();
    }

    public void setIdentitySearch(boolean searchIdentities) {
        this.getQuery().setIdentitySearch(searchIdentities);
    }

    public boolean isIdentitySearch() {
        return this.getQuery().isIdentitySearch();
    }

    public void setSearchAll(boolean searchAll) {
        this.getQuery().setSearchAll(searchAll);
    }

    public boolean isSearchAll() {
        return this.getQuery().isSearchAll();
    }

    @Override
    protected ResultSet<T> convert(ResultSet<ObjectSet> set) {
        return new EntityResultSetAdapter((EntityObjectSetResultSet)set, this.context);
    }
}

