/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import echopointng.DateField;
import java.util.Date;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.web.component.bound.BoundCheckBox;
import org.openvpms.web.component.bound.BoundDateFieldFactory;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.ModifiableListeners;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.util.ComponentHelper;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;

public class DateRange {
    private final FocusGroup focus;
    private final boolean showAll;
    private final SimpleProperty all = new SimpleProperty("all", (Object)true, Boolean.class, Messages.get((String)"daterange.all"));
    private final SimpleProperty from = new SimpleProperty("from", null, Date.class, Messages.get((String)"daterange.from"));
    private final SimpleProperty to = new SimpleProperty("to", null, Date.class, Messages.get((String)"daterange.to"));
    private final ModifiableListener fromListener;
    private final ModifiableListener toListener;
    private final ModifiableListeners listeners = new ModifiableListeners();
    private ComponentState allDates;
    private ComponentState fromDate;
    private ComponentState toDate;
    private Component component;

    public DateRange() {
        this(true);
    }

    public DateRange(boolean showAll) {
        this(showAll, DateRules.getToday());
    }

    public DateRange(boolean showAll, Date date) {
        this(showAll, date, date);
    }

    public DateRange(boolean showAll, Date from, Date to) {
        this.showAll = showAll;
        this.focus = new FocusGroup("DateRange");
        if (showAll) {
            this.all.addModifiableListener(modifiable -> this.onAllDatesChanged());
        }
        this.fromListener = modifiable -> this.onFromChanged();
        this.toListener = modifiable -> this.onToChanged();
        this.setFrom(from);
        this.setTo(to);
        this.from.addModifiableListener(this.fromListener);
        this.to.addModifiableListener(this.toListener);
    }

    public Date getFrom() {
        return this.getAllDates() ? null : this.getDate(this.from);
    }

    public void setFrom(Date date) {
        this.setFrom(date, false);
    }

    public Date getTo() {
        return this.getAllDates() ? null : this.getDate(this.to);
    }

    public void setTo(Date date) {
        this.to.setValue(date);
    }

    public void setAllDates(boolean selected) {
        if (this.showAll) {
            this.all.setValue(selected);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.allDates != null) {
            this.allDates.getComponent().setEnabled(enabled);
        }
        if (enabled && !this.getAllDates()) {
            this.setDateFieldsEnabled(true);
        } else {
            this.setDateFieldsEnabled(false);
        }
    }

    public boolean getAllDates() {
        return this.showAll && this.all.getValue() != null && (Boolean)this.all.getValue() != false;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = this.doLayout(this.getContainer());
        }
        return this.component;
    }

    public void setContainer(Component container) {
        this.component = this.doLayout(container);
    }

    public FocusGroup getFocusGroup() {
        return this.focus;
    }

    public void addListener(ModifiableListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeListener(ModifiableListener listener) {
        this.listeners.removeListener(listener);
    }

    protected void setFrom(Date date, boolean disable) {
        if (disable) {
            this.from.removeModifiableListener(this.fromListener);
        }
        this.from.setValue(date);
        if (disable) {
            this.from.addModifiableListener(this.fromListener);
        }
    }

    protected void setTo(Date date, boolean disable) {
        if (disable) {
            this.to.removeModifiableListener(this.toListener);
        }
        this.to.setValue(date);
        if (disable) {
            this.to.addModifiableListener(this.toListener);
        }
    }

    protected Component doLayout(Component container) {
        this.fromDate = this.createFromDate(this.from);
        this.toDate = this.createToDate(this.to);
        this.allDates = this.showAll ? this.createAllDates(this.all) : null;
        if (this.allDates != null) {
            container.add((Component)this.allDates.getLabel());
            container.add(this.allDates.getComponent());
            this.focus.add(this.allDates.getComponent());
        }
        container.add((Component)this.fromDate.getLabel());
        container.add(this.fromDate.getComponent());
        container.add((Component)this.toDate.getLabel());
        container.add(this.toDate.getComponent());
        this.setDateFieldsEnabled(!this.getAllDates());
        this.focus.add(this.fromDate.getComponent());
        this.focus.add(this.toDate.getComponent());
        return container;
    }

    protected Component getContainer() {
        return RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
    }

    protected ComponentState createAllDates(Property allDates) {
        return new ComponentState((Component)new BoundCheckBox(allDates), allDates);
    }

    protected ComponentState createFromDate(Property from) {
        return new ComponentState((Component)BoundDateFieldFactory.create(from), from);
    }

    protected ComponentState createToDate(Property to) {
        return new ComponentState((Component)BoundDateFieldFactory.create(to), to);
    }

    protected void onAllDatesChanged() {
        boolean enabled = !this.getAllDates();
        this.setDateFieldsEnabled(enabled);
        this.listeners.notifyListeners(this.all);
    }

    protected void updateFromDate(Date from, Date to) {
        if (from != null && to != null && DateRules.compareDates((Date)from, (Date)to) > 0) {
            this.setFrom(to, true);
        }
    }

    protected void updateToDate(Date from, Date to) {
        if (from != null && to != null && DateRules.compareDates((Date)from, (Date)to) > 0) {
            this.setTo(from, true);
        }
    }

    private void onFromChanged() {
        this.updateToDate(this.getFrom(), this.getTo());
        this.listeners.notifyListeners(this.all);
    }

    private void onToChanged() {
        this.updateFromDate(this.getFrom(), this.getTo());
        this.listeners.notifyListeners(this.to);
    }

    private void setDateFieldsEnabled(boolean enabled) {
        ComponentHelper.enable((Component)this.fromDate.getLabel(), enabled);
        ComponentHelper.enable((DateField)this.fromDate.getComponent(), enabled);
        ComponentHelper.enable((Component)this.toDate.getLabel(), enabled);
        ComponentHelper.enable((DateField)this.toDate.getComponent(), enabled);
    }

    private Date getDate(SimpleProperty property) {
        Date date = (Date)property.getValue();
        return DateRules.getDate((Date)date);
    }
}

