/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.Date;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;

public class DateNavigator {
    public static final DateNavigator DAY;
    public static final DateNavigator WEEK;
    public static final DateNavigator FORTNIGHT;
    public static final DateNavigator MONTH;

    public Date getCurrent() {
        return DateRules.getToday();
    }

    public Date getDate(Date date) {
        return date;
    }

    public Date getNext(Date date) {
        return DateRules.getNextDate((Date)date);
    }

    public Date getPrevious(Date date) {
        return DateRules.getPreviousDate((Date)date);
    }

    public Date getNextTerm(Date date) {
        return DateRules.getDate((Date)date, (int)1, (DateUnits)DateUnits.WEEKS);
    }

    public Date getPreviousTerm(Date date) {
        return DateRules.getDate((Date)date, (int)-1, (DateUnits)DateUnits.WEEKS);
    }

    static {
        WEEK = DAY = new DateNavigator();
        FORTNIGHT = DAY;
        MONTH = new DateNavigator(){

            @Override
            public Date getNextTerm(Date date) {
                return DateRules.getDate((Date)DateRules.getMonthStart((Date)date), (int)1, (DateUnits)DateUnits.MONTHS);
            }

            @Override
            public Date getPreviousTerm(Date date) {
                Date result = DateRules.getMonthStart((Date)date);
                if (DateRules.dateEquals((Date)result, (Date)date)) {
                    result = DateRules.getDate((Date)result, (int)-1, (DateUnits)DateUnits.MONTHS);
                }
                return result;
            }
        };
    }
}

