/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupFieldFactory;
import org.openvpms.web.component.im.query.AbstractArchetypeQuery;
import org.openvpms.web.component.im.query.ActStatuses;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.util.CollectionHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.LabelFactory;

public abstract class ActQuery<T>
extends AbstractArchetypeQuery<T> {
    public static final SortConstraint[] DESCENDING_START_TIME = new SortConstraint[]{new NodeSortConstraint("startTime", false), new NodeSortConstraint("id")};
    public static final SortConstraint[] ASCENDING_START_TIME = new SortConstraint[]{new NodeSortConstraint("startTime", true), new NodeSortConstraint("id")};
    private final ActStatuses statusLookups;
    private String participant;
    private String participation;
    private Reference entityId;
    private String[] requiredShortNames;
    private String[] statuses;
    private LookupField statusSelector;

    public ActQuery(Entity entity, String participant, String participation, String[] shortNames, ActStatuses statuses, Class<T> type) {
        super(shortNames, (Class)type);
        String[] stringArray;
        String defaultStatus;
        this.setParticipantConstraint(entity, participant, participation);
        this.statusLookups = statuses;
        String string = defaultStatus = this.statusLookups != null ? this.statusLookups.getDefaultCode() : null;
        if (defaultStatus != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = defaultStatus;
        } else {
            stringArray = new String[]{};
        }
        this.statuses = stringArray;
        this.setDefaultSortConstraint(DESCENDING_START_TIME);
    }

    public ActQuery(Entity entity, String participant, String participation, String[] shortNames, Class<T> type) {
        this(entity, participant, participation, shortNames, true, new String[0], type);
    }

    public ActQuery(Entity entity, String participant, String participation, String[] shortNames, boolean primaryOnly, String[] statuses, Class<T> type) {
        super(shortNames, primaryOnly, (Class)type);
        this.setParticipantConstraint(entity, participant, participation);
        this.statuses = statuses;
        this.statusLookups = null;
        this.setDefaultSortConstraint(DESCENDING_START_TIME);
    }

    public void setEntity(Entity entity) {
        this.entityId = entity != null ? entity.getObjectReference() : null;
    }

    public void setRequiredShortNames(String[] shortNames) {
        this.requiredShortNames = shortNames;
    }

    public void setStatus(String status) {
        String[] stringArray;
        if (status == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = status;
        }
        this.setStatuses(stringArray);
    }

    public void setStatuses(String[] statuses) {
        this.statuses = statuses == null ? new String[0] : statuses;
        if (this.statuses.length == 0) {
            this.updateStatusSelector(null);
        } else if (this.statuses.length == 1) {
            this.updateStatusSelector(this.statuses[0]);
        }
    }

    @Override
    public ResultSet<T> query(SortConstraint[] sort) {
        ResultSet result = null;
        if (this.participant == null || this.entityId != null) {
            result = this.createResultSet(sort);
        }
        return result;
    }

    @Override
    public ShortNameConstraint getArchetypes() {
        ShortNameConstraint result;
        ShortNameConstraint constraint = super.getArchetypes();
        if (this.requiredShortNames == null) {
            result = constraint;
        } else {
            String[] shortNames = constraint.getShortNames();
            shortNames = CollectionHelper.concat(shortNames, this.requiredShortNames);
            result = new ShortNameConstraint(shortNames, constraint.isPrimaryOnly(), true);
        }
        return result;
    }

    @Override
    protected ShortNameConstraint getArchetypeConstraint() {
        String type = this.getShortName();
        ShortNameConstraint archetypes = type == null ? this.getArchetypes() : this.getArchetypeConstraint(type);
        archetypes.setAlias("act");
        return archetypes;
    }

    protected void setParticipantConstraint(Entity entity, String nodeName, String shortName) {
        this.setEntity(entity);
        this.participant = nodeName;
        this.participation = shortName;
    }

    protected ParticipantConstraint getParticipantConstraint() {
        ParticipantConstraint result = null;
        Reference entityId = this.getEntityId();
        if (entityId != null) {
            result = new ParticipantConstraint(this.participant, this.participation, entityId);
        }
        return result;
    }

    protected ShortNameConstraint getArchetypeConstraint(String shortName) {
        ShortNameConstraint result;
        if (this.requiredShortNames == null) {
            result = new ShortNameConstraint(shortName, this.isPrimaryOnly(), true);
        } else {
            String[] shortNames = CollectionHelper.concat(this.requiredShortNames, shortName);
            result = new ShortNameConstraint(shortNames, this.isPrimaryOnly(), true);
        }
        return result;
    }

    protected Reference getEntityId() {
        return this.entityId;
    }

    protected Date getFrom() {
        return null;
    }

    protected Date getTo() {
        return null;
    }

    protected ActStatuses getStatusLookups() {
        return this.statusLookups;
    }

    protected String[] getStatuses() {
        String[] statuses = this.statuses;
        if (statuses.length == 0 && this.statusLookups != null && this.statusLookups.getExcluded() != null) {
            statuses = new String[]{this.statusLookups.getExcluded()};
        }
        return statuses;
    }

    protected boolean excludeStatuses() {
        String[] statuses = this.getStatuses();
        if (statuses.length == 1 && this.statusLookups != null) {
            String excluded = this.statusLookups.getExcluded();
            return statuses[0].equals(excluded);
        }
        return false;
    }

    protected void onStatusChanged() {
        this.setStatus(this.statusSelector.getSelectedCode());
        this.onQuery();
    }

    protected void addStatusSelector(Component container) {
        if (this.statusLookups != null) {
            this.statusSelector = LookupFieldFactory.create(this.statusLookups, true);
            this.statusSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent e) {
                    ActQuery.this.onStatusChanged();
                }
            });
            if (this.statuses != null && this.statuses.length == 1) {
                this.updateStatusSelector(this.statuses[0]);
            } else {
                String defaultStatus = this.statusSelector.getSelectedCode();
                if (defaultStatus != null) {
                    this.setStatus(defaultStatus);
                }
            }
            container.add((Component)LabelFactory.create((String)"actquery.status"));
            container.add((Component)this.statusSelector);
            this.getFocusGroup().add((Component)this.statusSelector);
        }
    }

    protected LookupField getStatusSelector() {
        return this.statusSelector;
    }

    private void updateStatusSelector(String status) {
        if (this.statusSelector != null) {
            this.statusSelector.setSelected(status);
        }
    }
}

