/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.io.Serializable;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.TableModelListener;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractTableBrowser;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserState;
import org.openvpms.web.component.im.query.EmptyResultSet;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.component.im.query.QueryState;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTable;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.im.table.PagedIMTableModel;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.button.ButtonRow;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.focus.FocusGroup;

public abstract class AbstractQueryBrowser<T>
extends AbstractTableBrowser<T>
implements QueryBrowser<T> {
    private final Query<T> query;
    private SortConstraint[] sort;
    private static final String QUERY_ID = "query";

    public AbstractQueryBrowser(Query<T> query, SortConstraint[] sort, IMTableModel<T> model, LayoutContext context) {
        super(model, context);
        this.query = query;
        this.sort = sort;
        this.query.addQueryListener(this::onQuery);
        this.getFocusGroup().add(query.getFocusGroup());
    }

    @Override
    public Query<T> getQuery() {
        return this.query;
    }

    @Override
    public void query() {
        Component component = this.getComponent();
        ResultSet<T> set = this.doQuery();
        boolean hasResults = set != null && this.hasResults(set);
        this.doLayout(component, hasResults);
        if (set == null) {
            set = new EmptyResultSet(this.getQuery().getMaxResults());
        }
        PagedIMTable<T> table = this.getTable();
        table.setResultSet(set);
        this.setFocusOnResults();
    }

    @Override
    public ResultSet<T> getResultSet() {
        PagedIMTable table = this.getTable(false);
        if (table != null) {
            ResultSet set = table.getResultSet();
            try {
                if (set != null) {
                    return set.clone();
                }
            }
            catch (CloneNotSupportedException exception) {
                throw new IllegalStateException(exception);
            }
        }
        return null;
    }

    @Override
    public BrowserState getBrowserState() {
        Memento state = new Memento(this);
        return state.getPage() != -1 ? state : null;
    }

    @Override
    public void setBrowserState(BrowserState state) {
        int page;
        Memento memento = (Memento)state;
        if (memento.getQueryState() != null) {
            this.getQuery().setQueryState(memento.getQueryState());
        }
        if ((page = memento.getPage()) != -1) {
            this.query();
            PagedIMTable pagedTable = this.getTable();
            PagedIMTableModel model = pagedTable.getModel();
            int sortColumn = memento.getSortColumn();
            boolean ascending = memento.isSortedAscending();
            if (sortColumn != model.getSortColumn() || ascending != model.isSortedAscending()) {
                model.sort(sortColumn, ascending);
            }
            while (page >= 0) {
                if (model.setPage(page)) {
                    int row = memento.getSelectedRow();
                    if (row < 0) break;
                    IMTable table = pagedTable.getTable();
                    List objects = table.getObjects();
                    if (page != memento.getPage()) {
                        row = objects.size() - 1;
                    } else if (row >= objects.size()) {
                        row = objects.size() - 1;
                    }
                    if (row < 0) break;
                    table.getSelectionModel().setSelectedIndex(row, true);
                    break;
                }
                --page;
            }
        }
    }

    protected void setSortConstraint(SortConstraint[] sort) {
        this.sort = sort;
    }

    @Override
    protected void doLayout() {
        super.doLayout();
        if (this.query.isAuto()) {
            this.query();
        }
    }

    @Override
    protected void doLayout(Component container) {
        Extent height;
        Component row = this.doQueryLayout();
        if (container instanceof SplitPane && (height = this.query.getHeight()) != null) {
            ((SplitPane)container).setSeparatorPosition(height);
        }
        container.add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{row}));
    }

    protected Component doQueryLayout() {
        Component component = this.query.getComponent();
        FocusGroup group = this.getFocusGroup();
        group.add(this.query.getFocusGroup());
        ButtonRow row = new ButtonRow(group);
        row.add(component);
        row.addButton(QUERY_ID, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AbstractQueryBrowser.this.onQuery();
            }
        });
        return row;
    }

    protected ResultSet<T> doQuery() {
        ResultSet<T> result = null;
        try {
            result = this.sort != null ? this.query.query(this.sort) : this.query.query();
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
        if (result == null) {
            result = new EmptyResultSet(this.query.getMaxResults());
        }
        return result;
    }

    @Override
    protected void initTableModel(IMTableModel<T> model) {
        super.initTableModel(model);
        model.addTableModelListener((TableModelListener & Serializable)event -> {
            ResultSet set;
            PagedIMTable table = this.getTable();
            if (table != null && (set = table.getResultSet()) != null) {
                this.setSortConstraint(set.getSortConstraints());
            }
        });
    }

    private void onQuery() {
        this.query();
        this.notifyBrowserListeners();
    }

    protected static class Memento<T>
    implements BrowserState {
        private final QueryState queryState;
        private final int selectedRow;
        private final int page;
        private int sortColumn;
        private boolean sortAscending;

        public Memento(AbstractQueryBrowser<T> browser) {
            this.queryState = browser.getQuery().getQueryState();
            PagedIMTable table = browser.getTable();
            this.selectedRow = table.getTable().getSelectionModel().getMinSelectedIndex();
            this.sortColumn = table.getModel().getSortColumn();
            ResultSet set = table.getResultSet();
            if (set != null) {
                this.page = set.lastIndex();
                this.sortAscending = table.getModel().isSortedAscending();
            } else {
                this.page = -1;
                this.sortAscending = true;
            }
        }

        public QueryState getQueryState() {
            return this.queryState;
        }

        public int getPage() {
            return this.page;
        }

        public int getSelectedRow() {
            return this.selectedRow;
        }

        public int getSortColumn() {
            return this.sortColumn;
        }

        public boolean isSortedAscending() {
            return this.sortAscending;
        }

        @Override
        public boolean supports(Browser<?> browser) {
            return browser instanceof AbstractQueryBrowser;
        }

        @Override
        public boolean supports(String[] shortNames, Class<?> type) {
            return this.queryState != null && this.queryState.supports(type, shortNames);
        }

        @Override
        public boolean isEmpty() {
            return this.page == -1;
        }
    }
}

