/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.business.dao.im.Page;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.web.component.im.query.AbstractResultSet;

public abstract class AbstractListResultSet<T>
extends AbstractResultSet<T> {
    private final List<T> objects;

    public AbstractListResultSet(List<T> objects, int pageSize) {
        super(pageSize);
        this.objects = objects;
        this.reset();
    }

    @Override
    public int getResults() {
        return this.objects.size();
    }

    @Override
    public int getEstimatedResults() {
        return this.getResults();
    }

    @Override
    public boolean isEstimatedActual() {
        return true;
    }

    @Override
    public void setDistinct(boolean distinct) {
    }

    @Override
    public boolean isDistinct() {
        return false;
    }

    @Override
    protected IPage<T> get(int page) {
        int from;
        Page result = null;
        int maxResults = this.getPageSize();
        if (page == 0) {
            from = 0;
        } else {
            int n = from = maxResults == -1 ? this.objects.size() : page * maxResults;
        }
        if (from < this.objects.size()) {
            int to = maxResults == -1 || from + maxResults >= this.objects.size() ? this.objects.size() : from + maxResults;
            ArrayList<T> rows = new ArrayList<T>(this.objects.subList(from, to));
            result = new Page(rows, page * maxResults, maxResults, this.objects.size());
        }
        return result;
    }

    protected List<T> getObjects() {
        return this.objects;
    }
}

