/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import nextapp.echo2.app.CheckBox;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractArchetypeQuery;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.resource.i18n.Messages;

public abstract class AbstractEntityQuery<T>
extends AbstractArchetypeQuery<T> {
    private final boolean checkIdentity;
    private boolean searchAll;
    private CheckBox identity;
    private static final String IDENTITY_SEARCH_ID = "entityquery.identity";

    public AbstractEntityQuery(String[] shortNames) {
        super(shortNames, true);
        this.checkIdentity = true;
        this.setDefaultSortConstraint(NAME_SORT_CONSTRAINT);
        QueryFactory.initialise(this);
    }

    public AbstractEntityQuery(String[] shortNames, Class type) {
        this(shortNames, true, type);
    }

    public AbstractEntityQuery(String[] shortNames, boolean checkIdentity, Class type) {
        super(shortNames, type);
        this.checkIdentity = checkIdentity;
        this.setDefaultSortConstraint(NAME_SORT_CONSTRAINT);
        QueryFactory.initialise(this);
    }

    @Override
    public ResultSet<T> query(SortConstraint[] sort) {
        ResultSet result = null;
        if (this.canQueryOnName()) {
            result = this.createResultSet(sort);
        } else {
            ErrorHelper.show(Messages.format((String)"entityquery.error.nameLength", (Object[])new Object[]{this.getValueMinLength()}));
        }
        return result;
    }

    @Override
    public void setValue(String value) {
        super.setValue(value);
        if (this.checkIdentity) {
            this.checkIdentityName(value);
        }
    }

    public void setIdentitySearch(boolean searchIdentities) {
        this.getIdentitySearch().setSelected(searchIdentities);
    }

    public boolean isIdentitySearch() {
        return this.getIdentitySearch().isSelected();
    }

    public void setSearchAll(boolean searchAll) {
        this.searchAll = searchAll;
    }

    public boolean isSearchAll() {
        return this.searchAll;
    }

    protected CheckBox getIdentitySearch() {
        if (this.identity == null) {
            this.identity = new CheckBox();
            this.identity.setSelected(false);
        }
        return this.identity;
    }

    protected void addIdentitySearch(Component container) {
        Label label = LabelFactory.create((String)IDENTITY_SEARCH_ID);
        container.add((Component)label);
        container.add((Component)this.getIdentitySearch());
        this.getFocusGroup().add((Component)this.identity);
    }

    @Override
    protected void doLayout(Component container) {
        this.addShortNameSelector(container);
        this.addSearchField(container);
        this.addIdentitySearch(container);
        this.addActive(container);
        FocusHelper.setFocus((Component)this.getSearchField());
    }

    @Override
    protected void onSearchFieldChanged() {
        if (this.checkIdentity) {
            String value = this.getValue();
            this.checkIdentityName(value);
        }
        super.onSearchFieldChanged();
    }

    protected void checkIdentityName(String value) {
        if (value != null && (value = value.replaceAll("\\*", "")).matches("\\d+")) {
            this.setIdentitySearch(true);
        }
    }
}

