/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.AbstractQueryBrowser;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.EntityObjectSetQuery;
import org.openvpms.web.component.im.query.EntityObjectSetResultSet;
import org.openvpms.web.component.im.query.EntityQuery;
import org.openvpms.web.component.im.query.EntityResultSetAdapter;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryBrowserAdapter;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.NameDescObjectSetTableModel;
import org.openvpms.web.component.im.util.IMObjectHelper;

public class AbstractEntityBrowser<T extends Entity>
extends QueryBrowserAdapter<ObjectSet, T> {
    private final EntityQuery<T> query;
    private final Context context;
    private final NameDescObjectSetTableModel model;

    public AbstractEntityBrowser(EntityQuery<T> query, LayoutContext context) {
        this(query, context, new NameDescObjectSetTableModel("entity", true, false));
    }

    public AbstractEntityBrowser(EntityQuery<T> query, LayoutContext context, NameDescObjectSetTableModel model) {
        this.query = query;
        this.context = context.getContext();
        this.model = model;
        this.setBrowser(this.createBrowser(query, context));
    }

    @Override
    public Query<T> getQuery() {
        return this.query;
    }

    @Override
    public ResultSet<T> getResultSet() {
        EntityObjectSetResultSet set = (EntityObjectSetResultSet)this.getBrowser().getResultSet();
        return set != null ? new EntityResultSetAdapter(set, this.context) : null;
    }

    @Override
    protected T convert(ObjectSet set) {
        IMObjectReference ref = set.getReference("entity.reference");
        return (T)((Entity)IMObjectHelper.getObject((Reference)ref, this.context));
    }

    protected Browser<ObjectSet> createBrowser(final EntityQuery<T> query, LayoutContext context) {
        EntityObjectSetQuery delegate = query.getQuery();
        return new AbstractQueryBrowser<ObjectSet>((Query)delegate, delegate.getDefaultSortConstraint(), (IMTableModel)this.model, context){

            @Override
            protected ResultSet<ObjectSet> doQuery() {
                ResultSet<ObjectSet> result = super.doQuery();
                boolean showArchetype = query.getShortName() == null && query.getShortNames().length > 1;
                AbstractEntityBrowser.this.model.showArchetype(showArchetype);
                AbstractEntityBrowser.this.model.setShowActive(query.getActive() == BaseArchetypeConstraint.State.BOTH);
                return result;
            }
        };
    }
}

