/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserListener;
import org.openvpms.web.component.im.query.BrowserState;
import org.openvpms.web.echo.focus.FocusGroup;

public abstract class AbstractBrowser<T>
implements Browser<T> {
    private final List<BrowserListener<T>> listeners = new ArrayList<BrowserListener<T>>();
    private final FocusGroup focusGroup = new FocusGroup(this.getClass().getName());

    @Override
    public void addBrowserListener(BrowserListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeBrowserListener(BrowserListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public BrowserState getBrowserState() {
        return null;
    }

    @Override
    public void setBrowserState(BrowserState state) {
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    protected void notifyBrowserListeners() {
        for (BrowserListener<T> listener : this.getBrowserListeners()) {
            listener.query();
        }
    }

    protected void notifySelected(T selected) {
        for (BrowserListener<T> listener : this.getBrowserListeners()) {
            listener.selected(selected);
        }
    }

    protected void notifyBrowsed(T browsed) {
        for (BrowserListener<T> listener : this.getBrowserListeners()) {
            listener.browsed(browsed);
        }
    }

    protected BrowserListener<T>[] getBrowserListeners() {
        return this.listeners.toArray(new BrowserListener[0]);
    }
}

