/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import org.openvpms.archetype.rules.product.ProductQueryFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.EntityResultSet;

public class ProductResultSet
extends EntityResultSet<Product> {
    private final Entity productType;
    private final String species;
    private final boolean useLocationProducts;
    private final Party location;
    private final Party stockLocation;

    public ProductResultSet(ShortNameConstraint archetypes, String value, boolean searchIdentities, Entity productType, String species, boolean useLocationProducts, Party location, Party stockLocation, SortConstraint[] sort, int rows) {
        super(archetypes, value, searchIdentities, null, sort, rows, true);
        this.productType = productType;
        this.species = species;
        this.location = location;
        this.stockLocation = stockLocation;
        this.useLocationProducts = useLocationProducts;
    }

    @Override
    protected ArchetypeQuery createQuery() {
        this.getArchetypes().setAlias("p");
        String[] archetypes = this.getArchetypes().getShortNames();
        ArchetypeQuery query = super.createQuery();
        if (this.productType != null) {
            query.add((IConstraint)Constraints.join((String)"type").add((IConstraint)Constraints.eq((String)"target", (Reference)this.productType.getObjectReference())));
        }
        if (this.species != null) {
            ProductQueryFactory.addSpeciesConstraint((ArchetypeQuery)query, (String[])archetypes, (String)this.species);
        }
        if (this.useLocationProducts && this.location != null) {
            ProductQueryFactory.addLocationConstraint((ArchetypeQuery)query, (String[])archetypes, (Party)this.location);
        }
        if (this.stockLocation != null) {
            ProductQueryFactory.addStockLocationConstraint((ArchetypeQuery)query, (String[])archetypes, (boolean)this.useLocationProducts, (Party)this.stockLocation);
        }
        return query;
    }
}

