/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.collections.Predicate;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.rules.supplier.SupplierRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.functor.NodeEquals;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.edit.AbstractIMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductParticipationEditor;
import org.openvpms.web.component.im.product.ProductQuery;
import org.openvpms.web.component.im.product.ProductTableModel;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.DefaultIMObjectTableBrowser;
import org.openvpms.web.component.im.query.ListQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.util.CollectionHelper;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class ProductReferenceEditor
extends AbstractIMObjectReferenceEditor<Product> {
    private final ProductParticipationEditor editor;
    private final IArchetypeService service;

    public ProductReferenceEditor(ProductParticipationEditor editor, Property property, LayoutContext context) {
        super(property, editor.getParent(), new DefaultLayoutContext(context, context.getHelpContext().topic("product")));
        this.editor = editor;
        this.service = ServiceHelper.getArchetypeService();
    }

    @Override
    protected void onSelected(Product product) {
        if (product != null && this.editor.getSupplier() != null && this.hasSuppliers(product)) {
            this.checkSupplier(product);
        } else {
            this.setProduct(product, null);
        }
    }

    @Override
    protected void onUpdated(Product product) {
        if (product != null && this.hasSuppliers(product)) {
            ProductSupplier productSupplier = this.editor.getProductSupplier();
            Party supplier = this.editor.getSupplier();
            if (productSupplier == null || supplier == null || !Objects.equals(supplier.getObjectReference(), productSupplier.getSupplierRef()) || !Objects.equals(product.getObjectReference(), productSupplier.getProductRef())) {
                List<EntityLink> relationships = this.getSupplierRelationships(product);
                if (relationships.isEmpty()) {
                    this.setProductSupplier(null);
                } else if (relationships.size() == 1) {
                    this.setProductSupplier(relationships.get(0));
                } else {
                    this.setProductSupplier(this.getPreferred(relationships));
                }
            }
        } else {
            this.setProductSupplier(null);
        }
    }

    @Override
    protected Query<Product> createQuery(String name) {
        Query<Product> query = super.createQuery(name);
        return this.getQuery(query);
    }

    @Override
    protected Browser<Product> createBrowser(Query<Product> query) {
        ProductQuery q = (ProductQuery)query;
        LayoutContext context = this.getLayoutContext();
        ProductTableModel model = new ProductTableModel(q, this.editor.getLocation(), context);
        return new DefaultIMObjectTableBrowser<Product>(query, model, context);
    }

    protected Query<Product> getQuery(Query<Product> query) {
        if (query instanceof ProductQuery) {
            String species;
            ProductQuery productQuery = (ProductQuery)query;
            Party patient = this.editor.getPatient();
            if (patient != null && (species = (String)IMObjectHelper.getValue((IMObject)patient, "species")) != null) {
                productQuery.setSpecies(species);
            }
            Party location = this.editor.getStockLocation();
            productQuery.setUseLocationProducts(this.editor.useLocationProducts());
            productQuery.setLocation(this.editor.getLocation());
            productQuery.setStockLocation(location);
            productQuery.setExcludeTemplateOnlyProducts(this.editor.getExcludeTemplateOnlyProducts());
        }
        return query;
    }

    @Override
    protected boolean isValidReference(Validator validator) {
        return true;
    }

    private void setProduct(Product product, EntityLink relationship) {
        this.setProductSupplier(relationship);
        this.setObject(product);
    }

    private void setProductSupplier(EntityLink relationship) {
        if (relationship != null) {
            this.editor.setProductSupplier(new ProductSupplier((Relationship)relationship, (IArchetypeService)ServiceHelper.getArchetypeService()));
        } else {
            this.editor.setProductSupplier(null);
        }
    }

    private void checkSupplier(final Product product) {
        Entity otherSupplier;
        SupplierRules rules = ServiceHelper.getBean(SupplierRules.class);
        if (!rules.isSuppliedBy(this.editor.getSupplier(), product) && (otherSupplier = this.getSupplier(product)) != null) {
            String title = Messages.get((String)"product.othersupplier.title");
            String message = Messages.format((String)"product.othersupplier.message", (Object[])new Object[]{product.getName(), otherSupplier.getName()});
            final ConfirmationDialog dialog = new ConfirmationDialog(title, message);
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    if ("ok".equals(dialog.getAction())) {
                        ProductReferenceEditor.this.checkProductSupplierRelationships(product);
                    } else {
                        ProductReferenceEditor.this.setProduct(null, null);
                    }
                }
            });
            dialog.show();
        } else {
            this.checkProductSupplierRelationships(product);
        }
    }

    private boolean hasSuppliers(Product product) {
        IMObjectBean bean = this.service.getBean((IMObject)product);
        return bean.hasNode("suppliers");
    }

    private Entity getSupplier(Product product) {
        IMObjectBean bean = this.service.getBean((IMObject)product);
        return (Entity)bean.getTarget("suppliers", Entity.class, Policies.active());
    }

    private void checkProductSupplierRelationships(final Product product) {
        List<EntityLink> relationships = this.getSupplierRelationships(product);
        if (relationships.isEmpty()) {
            this.setProduct(product, null);
        } else if (relationships.size() == 1) {
            this.setProduct(product, relationships.get(0));
        } else {
            EntityLink preferred = this.getPreferred(relationships);
            ListQuery<EntityLink> query = new ListQuery<EntityLink>(relationships, "entityLink.productSupplier", EntityLink.class);
            String title = Messages.get((String)"product.supplier.type");
            DefaultLayoutContext context = new DefaultLayoutContext(this.getLayoutContext());
            context.setComponentFactory(new TableComponentFactory(context));
            final Browser<EntityLink> browser = BrowserFactory.create(query, context);
            BrowserDialog<EntityLink> dialog = new BrowserDialog<EntityLink>(title, browser, context.getHelpContext());
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent event) {
                    EntityLink selected = (EntityLink)browser.getSelected();
                    if (selected != null) {
                        ProductReferenceEditor.this.setProduct(product, selected);
                    } else {
                        ProductReferenceEditor.this.setProduct(null, null);
                    }
                }
            });
            browser.query();
            browser.setSelected(preferred);
            dialog.show();
        }
    }

    private EntityLink getPreferred(List<EntityLink> relationships) {
        NodeEquals preferred;
        EntityLink result = null;
        if (!relationships.isEmpty() && (result = CollectionHelper.find(relationships, (Predicate)(preferred = new NodeEquals("preferred", (Object)true, (IArchetypeService)ServiceHelper.getArchetypeService())))) == null) {
            result = relationships.get(0);
        }
        return result;
    }

    private List<EntityLink> getSupplierRelationships(Product product) {
        IMObjectBean bean = this.service.getBean((IMObject)product);
        Party supplier = this.editor.getSupplier();
        return bean.getValues("suppliers", EntityLink.class, Predicates.activeNow().and(Predicates.targetEquals((IMObject)supplier)));
    }
}

