/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.math.BigDecimal;
import java.util.Date;
import nextapp.echo2.app.Extent;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextHelper;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductPriceLayoutStrategy;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.MutablePropertySet;
import org.openvpms.web.component.property.NumericPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class ProductPriceEditor
extends AbstractIMObjectEditor {
    private final ModifiableListener priceListener;
    private final ModifiableListener markupListener;
    private final ModifiableListener taxIncListener;
    private final ProductPriceRules rules;
    private final Party practice;
    private final Currency currency;
    private final SimpleProperty taxIncPrice = new SimpleProperty("taxIncPrice", (Object)BigDecimal.ZERO, BigDecimal.class, Messages.get((String)"product.price.taxinc"));
    private final boolean readOnly;
    private final ModifiableListener costListener;
    private static final String COST = "cost";
    private static final String MARKUP = "markup";
    private static final String PRICE = "price";
    private static final String MAX_DISCOUNT = "maxDiscount";
    private static final String FROM_DATE = "fromDate";
    private static final String TO_DATE = "toDate";

    public ProductPriceEditor(ProductPrice object, Product parent, LayoutContext layoutContext) {
        super((IMObject)object, (IMObject)parent, layoutContext);
        Context context = layoutContext.getContext();
        this.readOnly = this.getReadOnly(object, context.getUser());
        this.practice = context.getPractice();
        this.currency = ContextHelper.getPracticeCurrency(context);
        this.costListener = modifiable -> this.updatePrice();
        Property cost = this.getProperty(COST);
        cost.setTransformer(new NumericPropertyTransformer(cost, false, 3));
        cost.addModifiableListener(this.costListener);
        this.markupListener = modifiable -> this.updatePrice();
        this.getProperty(MARKUP).addModifiableListener(this.markupListener);
        this.priceListener = modifiable -> this.onPriceChanged();
        Property price = this.getProperty(PRICE);
        price.addModifiableListener(this.priceListener);
        price.setTransformer(new NumericPropertyTransformer(price, false, 3));
        this.rules = ServiceHelper.getBean(ProductPriceRules.class);
        this.taxIncListener = modifiable -> this.updatePriceFromTaxInclusivePrice();
        this.taxIncPrice.addModifiableListener(this.taxIncListener);
        this.updateTaxInclusivePrice();
    }

    public BigDecimal getCost() {
        return this.getProperty(COST).getBigDecimal(BigDecimal.ZERO);
    }

    public void setCost(BigDecimal cost) {
        this.getProperty(COST).setValue(cost);
    }

    public BigDecimal getMarkup() {
        return this.getProperty(MARKUP).getBigDecimal(BigDecimal.ZERO);
    }

    public void setMarkup(BigDecimal markup) {
        this.getProperty(MARKUP).setValue(markup);
    }

    public BigDecimal getPrice() {
        return this.getProperty(PRICE).getBigDecimal(BigDecimal.ZERO);
    }

    public void setPrice(BigDecimal price) {
        this.getProperty(PRICE).setValue(price);
    }

    public void setTaxInclusivePrice(BigDecimal price) {
        this.taxIncPrice.setValue(price);
    }

    public BigDecimal getTaxInclusivePrice() {
        return this.taxIncPrice.getBigDecimal(BigDecimal.ZERO);
    }

    public BigDecimal getMaxDiscount() {
        return this.getProperty(MAX_DISCOUNT).getBigDecimal(BigDecimal.ZERO);
    }

    public void setToDate(Date date) {
        this.getProperty(TO_DATE).setValue(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Property cost = this.getProperty(COST);
        Property markup = this.getProperty(MARKUP);
        Property price = this.getProperty(PRICE);
        try {
            cost.removeModifiableListener(this.costListener);
            markup.removeModifiableListener(this.markupListener);
            price.removeModifiableListener(this.priceListener);
            price.refresh();
            this.updateTaxInclusivePrice();
        }
        finally {
            cost.addModifiableListener(this.costListener);
            markup.addModifiableListener(this.markupListener);
            price.addModifiableListener(this.priceListener);
        }
    }

    public Date getFromDate() {
        return this.getObject().getFromDate();
    }

    public ProductPrice getObject() {
        return (ProductPrice)super.getObject();
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        this.taxIncPrice.setReadOnly(this.readOnly);
        return new LayoutStrategy(this.taxIncPrice, this.readOnly);
    }

    protected boolean isReadOnly() {
        return this.readOnly;
    }

    private boolean getReadOnly(ProductPrice price, User user) {
        boolean readOnly = false;
        if (!this.getObject().isNew() && !UserHelper.isAdmin(user)) {
            Date fromDate = price.getFromDate();
            readOnly = fromDate != null ? DateRules.compareDateToToday((Date)fromDate) < 0 : true;
        }
        return readOnly;
    }

    private void updatePrice() {
        try {
            Property property = this.getProperty(PRICE);
            property.removeModifiableListener(this.priceListener);
            property.setValue(this.calculateTaxExPrice());
            property.addModifiableListener(this.priceListener);
            if (this.currencyHasNonDefaultMinimumPrice()) {
                this.onPriceChanged();
            }
            this.updateMaxDiscount();
            this.updateTaxInclusivePrice();
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
    }

    private void onPriceChanged() {
        try {
            Property property = this.getProperty(MARKUP);
            property.removeModifiableListener(this.markupListener);
            property.setValue(this.calculateMarkup());
            property.addModifiableListener(this.markupListener);
            this.updateMaxDiscount();
            this.updateTaxInclusivePrice();
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
    }

    private void updateMaxDiscount() {
        Property property = this.getProperty(MAX_DISCOUNT);
        BigDecimal maxDiscount = property.getBigDecimal(BigDecimal.ZERO);
        property.setValue(this.calculateDiscount(maxDiscount));
    }

    private BigDecimal calculateTaxExPrice() {
        BigDecimal cost = this.getCost();
        BigDecimal markup = this.getMarkup();
        BigDecimal price = BigDecimal.ZERO;
        if (this.currency != null) {
            price = this.rules.getTaxExPrice(cost, markup);
        }
        return price;
    }

    private BigDecimal calculateMarkup() {
        BigDecimal cost = this.getCost();
        BigDecimal price = this.getPrice();
        return this.rules.getMarkup(cost, price);
    }

    private BigDecimal calculateDiscount(BigDecimal maxDiscount) {
        BigDecimal result;
        if (maxDiscount.compareTo(BigDecimal.ZERO) == 0) {
            result = BigDecimal.ZERO;
        } else {
            BigDecimal markup = this.getMarkup();
            result = this.rules.getMaxDiscount(markup);
        }
        return result;
    }

    private boolean currencyHasNonDefaultMinimumPrice() {
        if (this.currency != null) {
            BigDecimal minimumPrice = this.currency.getMinimumPrice();
            return !MathRules.isZero((BigDecimal)minimumPrice) && !MathRules.equals((BigDecimal)this.currency.getDefaultRoundingAmount(), (BigDecimal)minimumPrice);
        }
        return false;
    }

    private void updateTaxInclusivePrice() {
        Product product = (Product)this.getParent();
        if (product != null && this.practice != null && this.currency != null) {
            BigDecimal price = this.rules.getTaxIncPrice(this.getPrice(), product, this.practice, this.currency);
            this.taxIncPrice.removeModifiableListener(this.taxIncListener);
            this.taxIncPrice.setValue(price);
            this.taxIncPrice.addModifiableListener(this.taxIncListener);
        }
    }

    private void updatePriceFromTaxInclusivePrice() {
        Product product = (Product)this.getParent();
        if (product != null && this.practice != null && this.currency != null) {
            BigDecimal price = this.rules.getTaxExPrice(this.taxIncPrice.getBigDecimal(BigDecimal.ZERO), product, this.practice);
            this.setPrice(price);
            this.updateTaxInclusivePrice();
        }
    }

    private static class LayoutStrategy
    extends ProductPriceLayoutStrategy {
        private final boolean readOnly;

        public LayoutStrategy(Property taxIncPrice, boolean readOnly) {
            super(taxIncPrice);
            this.readOnly = readOnly;
        }

        @Override
        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            Property notes;
            if (this.readOnly) {
                MutablePropertySet set = new MutablePropertySet(properties);
                set.setReadOnly(ProductPriceEditor.PRICE);
                set.setReadOnly(ProductPriceEditor.COST);
                set.setReadOnly(ProductPriceEditor.MARKUP);
                set.setReadOnly(ProductPriceEditor.MAX_DISCOUNT);
                set.setReadOnly(ProductPriceEditor.FROM_DATE);
                set.setReadOnly(ProductPriceEditor.TO_DATE);
                properties = set;
            }
            if ((notes = properties.get("notes")) != null) {
                this.addComponent(this.createMultiLineText(notes, 1, 2, new Extent(80, 128), context));
            }
            return super.apply(object, properties, parent, context);
        }
    }
}

