/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.PricingGroupFilter;
import org.openvpms.web.component.im.product.ProductPriceTableModel;
import org.openvpms.web.component.im.query.IMObjectListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.view.IMObjectTableCollectionViewer;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.event.ActionListener;

public class ProductPriceCollectionViewer
extends IMObjectTableCollectionViewer {
    private final PricingGroupFilter filter;

    public ProductPriceCollectionViewer(CollectionProperty property, IMObject parent, LayoutContext layout) {
        super(property, parent, layout);
        this.filter = new PricingGroupFilter(layout);
    }

    @Override
    protected Component doLayout() {
        Component component = super.doLayout();
        if (this.filter.needsFilter()) {
            component.add(this.filter.getComponent(), 0);
            this.filter.setListener(new ActionListener(){

                public void onAction(ActionEvent event) {
                    ProductPriceCollectionViewer.this.populateTable();
                }
            });
        }
        return component;
    }

    @Override
    protected ResultSet<IMObject> createResultSet() {
        List<IMObject> objects = this.filter.getPrices(this.getObjects());
        return new IMObjectListResultSet<IMObject>(objects, 15);
    }

    @Override
    protected IMTableModel<IMObject> createTableModel(LayoutContext context) {
        ProductPriceTableModel model = new ProductPriceTableModel(this.getProperty().getArchetypeRange(), context);
        if (this.filter.needsFilter()) {
            model.setShowPricingGroups(true);
        }
        return model;
    }
}

