/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.edit.AbstractIMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.CollectionPropertyEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.util.IMObjectCreator;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.palette.Palette;
import org.openvpms.web.system.ServiceHelper;

public class ProductLocationCollectionEditor
extends AbstractIMObjectCollectionEditor {
    private FocusGroup focusGroup;

    public ProductLocationCollectionEditor(CollectionProperty property, Entity object, LayoutContext context) {
        super(property, (IMObject)object, context);
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    @Override
    protected Component doLayout(LayoutContext context) {
        List locations = Collections.emptyList();
        Party practice = context.getContext().getPractice();
        if (practice != null) {
            locations = ServiceHelper.getBean(PracticeRules.class).getLocations(practice);
        }
        CollectionPropertyEditor editor = this.getCollectionPropertyEditor();
        LocationSelector palette = new LocationSelector(locations, editor);
        palette.setCellRenderer(IMObjectListCellRenderer.NAME);
        this.focusGroup = new FocusGroup(editor.getProperty().getDisplayName());
        this.focusGroup.add((Component)palette);
        return palette;
    }

    private static class LocationSelector
    extends Palette<IMObject> {
        private final CollectionPropertyEditor editor;

        public LocationSelector(List<Party> locations, CollectionPropertyEditor editor) {
            super(new ArrayList<Party>(locations), LocationSelector.getLocations(editor, locations));
            this.editor = editor;
        }

        protected void add(Object[] values) {
            String shortName = this.editor.getArchetypeRange()[0];
            for (Object value : values) {
                EntityLink link = (EntityLink)IMObjectCreator.create(shortName);
                link.setTarget(((IMObject)value).getObjectReference());
                this.editor.add((IMObject)link);
            }
        }

        protected void remove(Object[] values) {
            for (Object value : values) {
                IMObject object = (IMObject)value;
                Reference reference = object.getObjectReference();
                for (IMObject link : new ArrayList(this.editor.getObjects())) {
                    if (!Objects.equals(((EntityLink)link).getTarget(), reference)) continue;
                    this.editor.remove(link);
                }
            }
        }

        protected void sort(List<IMObject> values) {
            IMObjectSorter.sort(values, "name");
        }

        protected Label createAvailableLabel() {
            return this.createLabel("product.location.available");
        }

        protected Label createSelectedLabel() {
            return this.createLabel("product.location.notavailable");
        }

        private static List<IMObject> getLocations(CollectionPropertyEditor editor, List<Party> active) {
            ArrayList<IMObject> locations = new ArrayList<IMObject>();
            for (IMObject object : editor.getObjects()) {
                Reference target = ((Relationship)object).getTarget();
                Party location = IMObjectHelper.getObject(target, active);
                if (location == null) {
                    location = IMObjectHelper.getObject(target);
                }
                if (location == null) continue;
                locations.add((IMObject)location);
            }
            return locations;
        }
    }
}

