/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;

public class ProductIncludesLayoutStrategy
extends AbstractLayoutStrategy {
    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        boolean useLocationProducts = ProductHelper.useLocationProducts(context.getContext());
        ArchetypeNodes nodes = new ArchetypeNodes();
        nodes.exclude("source", "maxWeight", "weightUnits");
        nodes.simple("target");
        nodes.first("target");
        if (!useLocationProducts) {
            nodes.exclude("skipIfMissing");
        }
        this.setArchetypeNodes(nodes);
        ComponentState minWeight = this.createComponent(properties.get("minWeight"), parent, context);
        ComponentState maxWeight = this.createComponent(properties.get("maxWeight"), parent, context);
        ComponentState weightUnits = this.createComponent(properties.get("weightUnits"), parent, context);
        Label label = LabelFactory.create();
        label.setText("-");
        Row row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{minWeight.getComponent(), label, maxWeight.getComponent(), weightUnits.getComponent()});
        FocusGroup weight = new FocusGroup("weight", new Component[]{minWeight.getComponent(), maxWeight.getComponent(), weightUnits.getComponent()});
        String displayName = Messages.get((String)"product.weight");
        this.addComponent(new ComponentState((Component)row, minWeight.getProperty(), weight, displayName));
        return super.apply(object, properties, parent, context);
    }
}

