/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.math.BigDecimal;
import org.openvpms.component.business.domain.im.common.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.ProductIncludesLayoutStrategy;
import org.openvpms.web.component.im.relationship.EntityLinkEditor;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;

public class ProductIncludesEditor
extends EntityLinkEditor {
    static final String MIN_WEIGHT = "minWeight";
    static final String MAX_WEIGHT = "maxWeight";
    static final String WEIGHT_UNITS = "weightUnits";
    static final String LOW_QUANTITY = "lowQuantity";
    static final String HIGH_QUANTITY = "highQuantity";

    public ProductIncludesEditor(EntityLink object, IMObject parent, LayoutContext layoutContext) {
        super((org.openvpms.component.model.entity.EntityLink)object, parent, layoutContext);
        this.getProperty(LOW_QUANTITY).addModifiableListener(new ModifiableListener(){

            @Override
            public void modified(Modifiable modifiable) {
                ProductIncludesEditor.this.onLowQuantityChanged();
            }
        });
        this.getProperty(HIGH_QUANTITY).addModifiableListener(new ModifiableListener(){

            @Override
            public void modified(Modifiable modifiable) {
                ProductIncludesEditor.this.onHighQuantityChanged();
            }
        });
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateWeight(validator);
    }

    private boolean validateWeight(Validator validator) {
        boolean valid = true;
        Property minWeight = this.getProperty(MIN_WEIGHT);
        Property maxWeight = this.getProperty(MAX_WEIGHT);
        BigDecimal min = minWeight.getBigDecimal(BigDecimal.ZERO);
        BigDecimal max = maxWeight.getBigDecimal(BigDecimal.ZERO);
        if (min.compareTo(BigDecimal.ZERO) != 0 || max.compareTo(BigDecimal.ZERO) != 0) {
            if (min.compareTo(max) >= 0) {
                validator.add((Modifiable)this, new ValidatorError(Messages.format((String)"product.template.weighterror", (Object[])new Object[]{min, max})));
                valid = false;
            } else if (this.getProperty(WEIGHT_UNITS).getString() == null) {
                validator.add((Modifiable)this, new ValidatorError(Messages.format((String)"product.template.noweightunits", (Object[])new Object[]{min, max})));
                valid = false;
            }
        }
        return valid;
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        ProductIncludesLayoutStrategy strategy = new ProductIncludesLayoutStrategy();
        strategy.addComponent(new ComponentState(this.getTargetEditor()));
        return strategy;
    }

    private void onLowQuantityChanged() {
        BigDecimal high;
        Property highQuantity = this.getProperty(HIGH_QUANTITY);
        Property lowQuantity = this.getProperty(LOW_QUANTITY);
        BigDecimal low = lowQuantity.getBigDecimal(BigDecimal.ZERO);
        if (low.compareTo(high = highQuantity.getBigDecimal(BigDecimal.ZERO)) > 0) {
            highQuantity.setValue(low);
        }
    }

    private void onHighQuantityChanged() {
        BigDecimal high;
        Property highQuantity = this.getProperty(HIGH_QUANTITY);
        Property lowQuantity = this.getProperty(LOW_QUANTITY);
        BigDecimal low = lowQuantity.getBigDecimal(BigDecimal.ZERO);
        if (low.compareTo(high = highQuantity.getBigDecimal(BigDecimal.ZERO)) > 0) {
            lowQuantity.setValue(high);
        }
    }
}

