/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.util.List;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.model.archetype.ArchetypeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.WeightRangeTableHelper;
import org.openvpms.web.component.im.table.DescriptorTableColumn;
import org.openvpms.web.component.im.table.DescriptorTableModel;
import org.openvpms.web.resource.i18n.Messages;

public class ProductDoseTableModel
extends DescriptorTableModel<IMObject> {
    private static final int SPECIES_INDEX = 6;
    private static final int WEIGHT_INDEX = 7;
    private static final int RATE_INDEX = 8;
    private static final int QUANTITY_INDEX = 9;

    public ProductDoseTableModel(String[] shortNames, LayoutContext context) {
        super(shortNames, context);
    }

    @Override
    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        return null;
    }

    @Override
    protected Object getValue(IMObject object, TableColumn column, int row) {
        Object result;
        switch (column.getModelIndex()) {
            case 6: {
                result = this.getSpecies(object);
                break;
            }
            case 7: {
                result = WeightRangeTableHelper.getWeightRange(object);
                break;
            }
            default: {
                result = super.getValue(object, column, row);
            }
        }
        return result;
    }

    @Override
    protected TableColumnModel createColumnModel(List<ArchetypeDescriptor> archetypes, LayoutContext context) {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        model.addColumn(this.createColumn(6, "entity.productDose", "species"));
        model.addColumn(ProductDoseTableModel.createTableColumn(7, "product.weight"));
        model.addColumn((TableColumn)new DescriptorTableColumn(8, "rate", archetypes));
        model.addColumn((TableColumn)new DescriptorTableColumn(9, "quantity", archetypes));
        return model;
    }

    private String getSpecies(IMObject object) {
        IMObjectBean bean = this.getBean(object);
        List values = bean.getValues("species", Lookup.class);
        return !values.isEmpty() ? ((Lookup)values.get(0)).getName() : Messages.get((String)"list.all");
    }

    private TableColumn createColumn(int modelIndex, String shortName, String node) {
        TableColumn column = new TableColumn(modelIndex);
        column.setHeaderValue((Object)this.getDisplayName(shortName, node));
        return column;
    }
}

