/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import org.openvpms.archetype.rules.finance.tax.CustomerTaxRules;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ServiceRatioService;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.product.CustomerPricingContext;
import org.openvpms.web.component.im.product.ProductPricingContext;

public class PricingContextFactory {
    private final PracticeRules practiceRules;
    private final LocationRules locationRules;
    private final ProductPriceRules priceRules;
    private final ServiceRatioService serviceRatioService;

    public PricingContextFactory(PracticeRules practiceRules, LocationRules locationRules, ProductPriceRules priceRules, ServiceRatioService serviceRatioService) {
        this.practiceRules = practiceRules;
        this.locationRules = locationRules;
        this.priceRules = priceRules;
        this.serviceRatioService = serviceRatioService;
    }

    public ProductPricingContext createProductPricingContext(Party practice, Party location) {
        Currency currency = this.getCurrency(practice);
        return new ProductPricingContext(currency, practice, location, this.priceRules, this.locationRules, this.serviceRatioService);
    }

    public ProductPricingContext createProductPricingContext(PricingGroup pricingGroup, Party practice, Party location) {
        Currency currency = this.getCurrency(practice);
        return new ProductPricingContext(currency, pricingGroup, practice, location, this.priceRules, this.serviceRatioService);
    }

    public CustomerPricingContext createCustomerPricingContext(Party customer, Party practice, Party location, ProductPriceRules priceRules, CustomerTaxRules taxRules) {
        Currency currency = this.getCurrency(practice);
        return new CustomerPricingContext(customer, location, currency, priceRules, this.locationRules, taxRules, this.serviceRatioService);
    }

    private Currency getCurrency(Party practice) {
        return this.practiceRules.getCurrency(practice);
    }
}

