/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.edit.AbstractPropertyEditor;
import org.openvpms.web.component.im.product.PricingContext;
import org.openvpms.web.component.im.query.IMObjectListResultSet;
import org.openvpms.web.component.im.table.AbstractIMObjectTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.popup.DropDown;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.resource.i18n.format.NumberFormatter;
import org.openvpms.web.system.ServiceHelper;

public class FixedPriceEditor
extends AbstractPropertyEditor {
    private final PricingContext pricingContext;
    private final Component container;
    private final TextField field;
    private final FocusGroup focus;
    private Product product;
    private BigDecimal serviceRatio;
    private Date date;
    private DropDown priceDropDown;
    private ProductPrice price;

    public FixedPriceEditor(Property property, PricingContext pricingContext) {
        super(property);
        this.pricingContext = pricingContext;
        this.date = new Date();
        this.field = BoundTextComponentFactory.createNumeric(property, StyleSheetHelper.getNumericLength());
        if (property.isReadOnly()) {
            this.field.setEnabled(false);
        }
        this.focus = new FocusGroup(property.getDisplayName());
        this.focus.add((Component)this.field);
        if (!property.isReadOnly()) {
            this.focus.add((Component)this.field);
        }
        this.container = RowFactory.create((Component[])new Component[]{this.field});
    }

    public void setProduct(Product product, BigDecimal serviceRatio) {
        this.product = product;
        this.serviceRatio = serviceRatio;
        this.updatePrices();
    }

    public BigDecimal getPrice() {
        return (BigDecimal)this.getProperty().getValue();
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public Component getComponent() {
        return this.container;
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.focus;
    }

    public ProductPrice getProductPrice() {
        return this.price;
    }

    public void setProductPrice(ProductPrice price) {
        this.price = price;
    }

    public void setServiceRatio(BigDecimal serviceRatio) {
        if (Objects.equals(serviceRatio, this.serviceRatio)) {
            this.serviceRatio = serviceRatio;
            this.updatePrices();
        }
    }

    private void onSelected(ProductPrice price) {
        this.price = price;
        if (price != null) {
            this.getProperty().setValue(this.getPrice(price));
        }
        this.priceDropDown.setExpanded(false);
    }

    private void updatePrices() {
        List<ProductPrice> prices;
        TextField component = this.field;
        Component table = null;
        if (this.product != null && !(prices = this.pricingContext.getFixedPrices(this.product, this.date)).isEmpty()) {
            table = this.createPriceTable(prices).getComponent();
        }
        if (table != null) {
            this.priceDropDown = new DropDown();
            this.priceDropDown.setTarget((Component)this.field);
            this.priceDropDown.setPopUpAlwaysOnTop(true);
            this.priceDropDown.setFocusOnExpand(true);
            this.priceDropDown.setPopUp(table);
            this.priceDropDown.setFocusComponent(table);
            component = this.priceDropDown;
        } else {
            this.priceDropDown = null;
        }
        this.container.removeAll();
        this.container.add((Component)component);
    }

    private PagedIMTable<IMObject> createPriceTable(List<ProductPrice> prices) {
        IMObjectListResultSet<ProductPrice> set = new IMObjectListResultSet<ProductPrice>(new ArrayList<ProductPrice>(prices), 20);
        final PagedIMTable<ProductPrice> table = new PagedIMTable<ProductPrice>(new PriceTableModel(), set);
        table.getTable().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                FixedPriceEditor.this.onSelected((ProductPrice)table.getTable().getSelected());
            }
        });
        return table;
    }

    private BigDecimal getPrice(ProductPrice price) {
        return this.pricingContext.getPrice(this.product, price, this.serviceRatio);
    }

    private class PriceTableModel
    extends AbstractIMObjectTableModel<IMObject> {
        private static final int NAME_INDEX = 0;
        private static final int PRICE_INDEX = 1;

        public PriceTableModel() {
            DefaultTableColumnModel model = new DefaultTableColumnModel();
            model.addColumn(PriceTableModel.createTableColumn(0, "table.imobject.name"));
            TableColumn price = new TableColumn(1);
            price.setHeaderValue((Object)DescriptorHelper.getDisplayName((String)"productPrice.fixedPrice", (String)"price", (ArchetypeService)ServiceHelper.getArchetypeService()));
            model.addColumn(price);
            this.setTableColumnModel((TableColumnModel)model);
        }

        @Override
        public SortConstraint[] getSortConstraints(int column, boolean ascending) {
            NodeSortConstraint[] result = null;
            switch (column) {
                case 0: {
                    result = new NodeSortConstraint[]{new NodeSortConstraint("name", ascending)};
                    break;
                }
                case 1: {
                    result = new NodeSortConstraint[]{new NodeSortConstraint("price", ascending)};
                }
            }
            return result;
        }

        @Override
        protected Object getValue(IMObject object, TableColumn column, int row) {
            String result = null;
            switch (column.getModelIndex()) {
                case 0: {
                    result = object.getName();
                    break;
                }
                case 1: {
                    result = TableHelper.rightAlign((String)NumberFormatter.formatCurrency((Number)FixedPriceEditor.this.getPrice((ProductPrice)object)));
                }
            }
            return result;
        }
    }
}

