/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.print;

import java.util.Map;
import org.openvpms.component.model.document.Document;
import org.openvpms.print.exception.PrinterException;
import org.openvpms.print.impl.i18n.PrintMessages;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.component.im.report.Reporter;
import org.openvpms.web.component.print.AbstractPrinter;

public abstract class AbstractIMPrinter<T>
extends AbstractPrinter
implements IMPrinter<T> {
    private final Reporter<T> reporter;

    public AbstractIMPrinter(Reporter<T> reporter, PrinterContext printerContext, Context context) {
        super(printerContext, context);
        this.reporter = reporter;
    }

    @Override
    public Iterable<T> getObjects() {
        return this.reporter.getObjects();
    }

    @Override
    public Reporter<T> getReporter() {
        return this.reporter;
    }

    @Override
    public void print(DocumentPrinter printer) {
        if (printer == null) {
            throw new PrinterException(PrintMessages.noPrinter());
        }
        if (printer.canUseJavaPrintServiceAPI() && this.reporter.canPrint()) {
            this.reporter.print(this.getProperties(printer));
        } else {
            Document document = this.reporter.getDocument();
            this.print(document, printer);
        }
    }

    public void setParameters(Map<String, Object> parameters) {
        this.reporter.setParameters(parameters);
    }

    public Map<String, Object> getParameters() {
        return this.reporter.getParameters();
    }

    public void setFields(Map<String, Object> fields) {
        this.reporter.setFields(fields);
    }

    @Override
    public Document getDocument() {
        return this.reporter.getDocument();
    }

    @Override
    public Document getDocument(String mimeType, boolean email) {
        return this.reporter.getDocument(mimeType, email);
    }

    protected T getObject() {
        return this.reporter.getObject();
    }
}

