/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.patient;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.table.AbstractEntityObjectSetTableModel;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.system.ServiceHelper;

public class PatientTableModel
extends AbstractEntityObjectSetTableModel {
    private final Context context;
    private final PatientRules rules;
    private boolean showOwner;
    private boolean showIdentity;
    private boolean showActive;
    private static final int OWNER_INDEX = 5;

    public PatientTableModel(Context context) {
        super("patient", "identity");
        this.context = context;
        this.rules = ServiceHelper.getBean(PatientRules.class);
        this.setTableColumnModel(this.createTableColumnModel());
    }

    public void showColumns(boolean owner, boolean identity, boolean active) {
        if (owner != this.showOwner || identity != this.showIdentity || active != this.showActive) {
            this.showOwner = owner;
            this.showIdentity = identity;
            this.showActive = active;
            this.setTableColumnModel(this.createTableColumnModel());
        }
    }

    @Override
    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        if (column == 5) {
            return new SortConstraint[]{new NodeSortConstraint("customer", "name", ascending), new NodeSortConstraint("patient", "name", true)};
        }
        return super.getSortConstraints(column, ascending);
    }

    protected TableColumnModel createTableColumnModel() {
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        model.addColumn(PatientTableModel.createTableColumn(0, "table.imobject.id"));
        model.addColumn(PatientTableModel.createTableColumn(1, "table.imobject.name"));
        if (this.showOwner) {
            model.addColumn(PatientTableModel.createTableColumn(5, "patienttablemodel.owner"));
        }
        model.addColumn(PatientTableModel.createTableColumn(2, "table.imobject.description"));
        if (this.showIdentity) {
            model.addColumn(PatientTableModel.createTableColumn(3, "table.entity.identity"));
        }
        if (this.showActive) {
            model.addColumn(PatientTableModel.createTableColumn(4, "table.imobject.active"));
        }
        return model;
    }

    @Override
    protected Object getValue(ObjectSet set, TableColumn column, int row) {
        Object result;
        int index = column.getModelIndex();
        switch (index) {
            case 5: {
                result = this.getOwner(set);
                break;
            }
            case 2: {
                result = this.getDescriptionLabel(set);
                break;
            }
            default: {
                result = super.getValue(set, column, row);
            }
        }
        return result;
    }

    protected Component getDescriptionLabel(ObjectSet set) {
        Label result;
        Party patient = (Party)this.getEntity(set);
        Label label = LabelFactory.create();
        label.setText(this.getDescription(set));
        if (this.rules.isDeceased(patient)) {
            Label deceased = LabelFactory.create((String)"patient.deceased", (String)"Patient.Deceased");
            result = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{label, deceased});
        } else {
            result = label;
        }
        return result;
    }

    protected Component getOwner(ObjectSet set) {
        Party owner;
        Component result = null;
        Party patient = (Party)this.getEntity(set);
        if (patient != null && (owner = this.rules.getOwner(patient)) != null) {
            IMObjectReferenceViewer viewer = new IMObjectReferenceViewer(owner.getObjectReference(), false, this.context);
            result = viewer.getComponent();
        }
        return result;
    }
}

