/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.patient;

import java.util.function.Supplier;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientSummaryFactory;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.system.ServiceHelper;

public class PatientSummaryViewer {
    public static Button createButton(LayoutContext context, Supplier<Party> patient) {
        Button button = ButtonFactory.create(null, (String)"button.info", () -> {
            Party entity = (Party)patient.get();
            if (entity != null) {
                PatientSummaryViewer.show(entity, context);
            }
        });
        button.setFocusTraversalParticipant(false);
        return button;
    }

    public static void show(Party patient, LayoutContext context) {
        PatientSummaryFactory factory = ServiceHelper.getBean(PatientSummaryFactory.class);
        final Component summary = factory.getSummary(patient, context);
        ModalDialog dialog = new ModalDialog("Information for " + patient.getName(), "SummaryDialog", PopupDialog.CLOSE){

            protected void doLayout() {
                this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{summary}));
            }
        };
        dialog.show();
    }
}

