/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.patient;

import java.util.Objects;
import nextapp.echo2.app.Button;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.alert.MandatoryAlerts;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextHelper;
import org.openvpms.web.component.im.customer.CustomerParticipationEditor;
import org.openvpms.web.component.im.edit.AbstractIMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.IMObjectReferenceEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.patient.PatientBrowser;
import org.openvpms.web.component.im.patient.PatientObjectSetQuery;
import org.openvpms.web.component.im.patient.PatientSummaryViewer;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryAdapter;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.factory.RowFactory;

public class PatientParticipationEditor
extends ParticipationEditor<Party> {
    private final MandatoryAlerts alerts;
    private CustomerParticipationEditor customerEditor;
    private Row row;

    public PatientParticipationEditor(Participation participation, Act parent, LayoutContext layout) {
        super(participation, parent, layout);
        if (!TypeHelper.isA((IMObject)participation, (String)"participation.patient")) {
            throw new IllegalArgumentException("Invalid participation type:" + participation.getArchetype());
        }
        Context context = this.getLayoutContext().getContext();
        this.alerts = new MandatoryAlerts(context, layout.getHelpContext());
        Reference patientRef = participation.getEntity();
        if (patientRef == null && parent.isNew()) {
            this.setEntity(context.getPatient());
        } else {
            Party patient = (Party)this.getObject(patientRef);
            if (patient != null && patient != context.getPatient()) {
                ContextHelper.setPatient(context, patient);
            }
        }
    }

    public void setCustomerParticipationEditor(CustomerParticipationEditor editor) {
        this.customerEditor = editor;
    }

    public void showAlerts() {
        this.alerts.show((Party)this.getEntity());
    }

    @Override
    public Component getComponent() {
        if (this.row == null) {
            Button info = PatientSummaryViewer.createButton(this.getLayoutContext(), this::getEntity);
            this.row = RowFactory.create((String)"CellSpacing", (Component[])new Component[]{super.getComponent(), info});
        }
        return this.row;
    }

    @Override
    protected IMObjectReferenceEditor<Party> createEntityEditor(Property property) {
        LayoutContext context = this.getLayoutContext();
        DefaultLayoutContext subContext = new DefaultLayoutContext(context, context.getHelpContext().topic("patient"));
        return new AbstractIMObjectReferenceEditor<Party>(property, this.getParent(), (LayoutContext)subContext, true){

            @Override
            public boolean setObject(Party object) {
                ContextHelper.setPatient(this.getLayoutContext().getContext(), object, PatientParticipationEditor.this.customerEditor == null);
                return super.setObject(object);
            }

            @Override
            protected void onSelected(Party object) {
                super.onSelected(object);
                PatientParticipationEditor.this.alerts.show(object);
            }

            @Override
            protected void onSelected(Party object, Browser<Party> browser) {
                Party customer;
                super.onSelected(object, browser);
                PatientParticipationEditor.this.alerts.show(object);
                if (PatientParticipationEditor.this.customerEditor != null && browser instanceof PatientBrowser && (customer = ((PatientBrowser)browser).getCustomer()) != null && !Objects.equals(customer, PatientParticipationEditor.this.customerEditor.getEntity())) {
                    PatientParticipationEditor.this.customerEditor.setEntity(customer);
                    PatientParticipationEditor.this.customerEditor.showAlerts();
                }
            }

            @Override
            protected boolean isValidReference(Reference reference) {
                Query query = this.createQuery(null);
                if (query instanceof QueryAdapter && ((QueryAdapter)query).getQuery() instanceof PatientObjectSetQuery) {
                    PatientObjectSetQuery q = (PatientObjectSetQuery)((QueryAdapter)query).getQuery();
                    q.setActiveOnly(false);
                }
                return query.selects(reference);
            }
        };
    }
}

