/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.lookup;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.web.component.im.lookup.AbstractLookupQuery;
import org.openvpms.web.component.im.lookup.LookupQuery;

public class LookupFilter
extends AbstractLookupQuery {
    private final LookupQuery query;
    private String[] codes;
    private Predicate predicate;

    public LookupFilter(LookupQuery query, boolean include, String ... codes) {
        this.query = query;
        this.predicate = include ? new Match() : new NotPredicate((Predicate)new Match());
        this.codes = codes;
    }

    public void setCodes(String ... codes) {
        this.codes = codes;
    }

    public String[] getCodes() {
        return this.codes;
    }

    @Override
    public List<Lookup> getLookups() {
        ArrayList<Lookup> result = new ArrayList<Lookup>();
        CollectionUtils.select(this.query.getLookups(), (Predicate)this.predicate, result);
        return result;
    }

    private class Match
    implements Predicate {
        private Match() {
        }

        public boolean evaluate(Object object) {
            Lookup lookup = (Lookup)object;
            for (String code : LookupFilter.this.codes) {
                if (!code.equals(lookup.getCode())) continue;
                return true;
            }
            return false;
        }
    }
}

