/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.lookup;

import java.util.ArrayList;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.event.ActionEvent;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.web.component.bound.BoundTextField;
import org.openvpms.web.component.edit.AbstractPropertyEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.lookup.LookupPropertyEditor;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.table.DefaultIMObjectTableModel;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.table.PagedIMTable;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.popup.DropDown;
import org.openvpms.web.resource.i18n.Messages;

public class DropdownLookupPropertyEditor
extends AbstractPropertyEditor
implements LookupPropertyEditor {
    private final LayoutContext context;
    private final LookupQuery query;
    private final SimpleProperty input;
    private final FocusGroup focusGroup;
    private final ModifiableListener listener;
    private final DropDown dropDown;
    private Lookup lookup;
    private PagedIMTable<Lookup> table;

    public DropdownLookupPropertyEditor(Property property, IMObject object, LayoutContext context) {
        super(property);
        this.context = context;
        this.query = this.createLookupQuery(property, object);
        this.focusGroup = new FocusGroup(this.getClass().getSimpleName());
        this.input = new SimpleProperty(property.getName(), null, String.class, property.getDisplayName());
        this.input.setDescription(property.getDescription());
        BoundTextField inputField = new BoundTextField(this.input);
        inputField.setStyleName("Selector");
        inputField.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                if (DropdownLookupPropertyEditor.this.table != null && !DropdownLookupPropertyEditor.this.dropDown.isExpanded()) {
                    DropdownLookupPropertyEditor.this.dropDown.setExpanded(true);
                    DropdownLookupPropertyEditor.this.table.getFocusGroup().setFocus();
                }
            }
        });
        this.dropDown = new DropDown();
        this.dropDown.setStyleName("default");
        this.dropDown.setTarget((Component)inputField);
        this.dropDown.setPopUpAlwaysOnTop(true);
        this.dropDown.setFocusOnExpand(true);
        this.listener = modifiable -> this.updateLookups(true);
        this.updateFromProperty();
    }

    @Override
    public void refresh() {
        this.updateFromProperty();
    }

    @Override
    public Component getComponent() {
        return this.dropDown;
    }

    @Override
    public FocusGroup getFocusGroup() {
        return this.focusGroup;
    }

    protected void setLookup(Lookup lookup) {
        this.lookup = lookup;
        this.updateText();
        Property property = this.getProperty();
        if (lookup == null) {
            property.setValue(null);
        } else if (property.isString()) {
            property.setValue(lookup.getCode());
        } else {
            property.setValue(lookup);
        }
    }

    protected LookupQuery createLookupQuery(Property property, IMObject object) {
        return new NodeLookupQuery((org.openvpms.component.model.object.IMObject)object, property);
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.isValidLookup(validator);
    }

    protected boolean isValidLookup(Validator validator) {
        boolean result = false;
        String text = StringUtils.trimToNull((String)this.input.getString());
        if (text == null && this.lookup == null) {
            result = true;
        } else if (this.lookup != null && StringUtils.equalsIgnoreCase((CharSequence)this.lookup.getName(), (CharSequence)text)) {
            result = true;
        } else {
            validator.add((Modifiable)this.getProperty(), Messages.format((String)"property.error.invalidvalue", (Object[])new Object[]{text, this.getProperty().getDisplayName()}));
        }
        return result;
    }

    protected boolean matches(Lookup lookup, String text) {
        return StringUtils.startsWithIgnoreCase((CharSequence)lookup.getName(), (CharSequence)text);
    }

    protected IMTableModel<Lookup> createTableModel(LayoutContext context) {
        return new DefaultIMObjectTableModel<Lookup>(true, false);
    }

    private void updateFromProperty() {
        this.lookup = this.getLookup();
        this.updateText();
        this.updateLookups(false);
    }

    private Lookup getLookup() {
        Object object = this.getProperty().getValue();
        if (object instanceof String) {
            return (Lookup)this.query.getLookup(object.toString());
        }
        if (object instanceof Lookup) {
            return (Lookup)object;
        }
        return null;
    }

    private void updateText() {
        try {
            this.input.removeModifiableListener(this.listener);
            if (this.lookup != null) {
                this.input.setValue(this.lookup.getName());
            } else {
                this.input.setValue(null);
            }
        }
        finally {
            this.input.addModifiableListener(this.listener);
        }
    }

    private void updateLookups(boolean showPopup) {
        List<Lookup> lookups;
        this.table = null;
        String text = StringUtils.trimToNull((String)this.input.getString());
        if (this.lookup != null) {
            if (StringUtils.equalsIgnoreCase((CharSequence)this.lookup.getName(), (CharSequence)text)) {
                text = null;
            } else if (text == null) {
                this.setLookup(null);
            }
        }
        if ((lookups = this.getMatchingLookups(this.query, text)).size() >= 1) {
            if (lookups.size() == 1) {
                this.setLookup(lookups.get(0));
                showPopup = false;
            }
            this.table = this.createTable(new ListResultSet<Lookup>(lookups, 5));
        }
        if (this.table != null) {
            this.table.getTable().setSelected(this.lookup);
            Column newValue = ColumnFactory.create((String)"Inset", (Component[])new Component[]{this.table.getComponent()});
            this.dropDown.setPopUp((Component)newValue);
            this.dropDown.setFocusComponent(this.table.getComponent());
        } else {
            Label component = LabelFactory.create((String)"imobject.none");
            Column newValue = ColumnFactory.create((String)"Inset", (Component[])new Component[]{component});
            this.dropDown.setPopUp((Component)newValue);
            this.dropDown.setFocusComponent(null);
        }
        if (showPopup) {
            this.dropDown.setExpanded(true);
        }
    }

    private List<Lookup> getMatchingLookups(LookupQuery query, String text) {
        ArrayList<Lookup> result = new ArrayList<Lookup>();
        for (org.openvpms.component.model.lookup.Lookup lookup : query.getLookups()) {
            if (text != null && !this.matches((Lookup)lookup, text)) continue;
            result.add((Lookup)lookup);
        }
        return result;
    }

    private PagedIMTable<Lookup> createTable(ResultSet<Lookup> set) {
        IMTableModel<Lookup> model = this.createTableModel(this.context);
        final PagedIMTable<Lookup> table = new PagedIMTable<Lookup>(model, set);
        table.getTable().addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                Lookup selected = (Lookup)table.getTable().getSelected();
                DropdownLookupPropertyEditor.this.setLookup(selected);
                DropdownLookupPropertyEditor.this.dropDown.setExpanded(false);
            }
        });
        return table;
    }
}

