/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.lookup;

import java.util.Objects;
import nextapp.echo2.app.list.ListModel;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.bound.Binder;
import org.openvpms.web.component.bound.SelectFieldBinder;
import org.openvpms.web.component.im.list.LookupListModel;
import org.openvpms.web.component.im.lookup.LookupField;
import org.openvpms.web.component.im.lookup.LookupQuery;
import org.openvpms.web.component.im.lookup.NodeLookupQuery;
import org.openvpms.web.component.property.Property;

public class BoundLookupField
extends LookupField {
    private final Binder binder;

    public BoundLookupField(Property property, IMObject parent) {
        this(property, new NodeLookupQuery(parent, property), false, property.isRequired() || parent.isNew());
    }

    public BoundLookupField(Property property, LookupQuery source) {
        this(property, source, false);
    }

    public BoundLookupField(Property property, LookupQuery source, boolean all) {
        this(property, source, all, property.isRequired());
    }

    public BoundLookupField(Property property, LookupListModel model) {
        this(property, model, property.isRequired());
    }

    protected BoundLookupField(Property property, LookupQuery source, boolean all, boolean setDefault) {
        this(property, new LookupListModel(source, all, !property.isRequired()), setDefault);
    }

    protected BoundLookupField(Property property, LookupListModel model, boolean setDefault) {
        super(model);
        this.binder = new SelectFieldBinder(this, property){

            @Override
            protected boolean equals(Object value, ListModel model, int index) {
                Object other = model.get(index);
                if (other instanceof String && value != null) {
                    value = value.toString();
                }
                return Objects.equals(value, other);
            }
        };
        if (!StringUtils.isEmpty((CharSequence)property.getDescription())) {
            this.setToolTipText(property.getDescription());
        }
        if (this.getSelected() == null && setDefault) {
            this.setDefaultSelection();
        }
    }

    @Override
    public boolean refresh() {
        boolean result = super.refresh();
        if (result) {
            this.binder.setProperty();
        }
        return result;
    }

    public void init() {
        super.init();
        this.binder.bind();
    }

    public void dispose() {
        super.dispose();
        this.binder.unbind();
    }
}

