/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.location;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.archetype.rules.practice.Location;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.list.IMObjectListModel;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.echo.factory.ComponentFactory;
import org.openvpms.web.system.ServiceHelper;

public class LocationSelectField
extends SelectField {
    public LocationSelectField(Party practice) {
        super(LocationSelectField.createModel(practice));
        this.initialise();
    }

    public LocationSelectField(User user, Party practice, boolean all) {
        super(LocationSelectField.createModel(user, practice, all, false));
        this.initialise();
    }

    public boolean isAllSelected() {
        return this.getModel().isAll(this.getSelectedIndex());
    }

    public Location getSelected() {
        return this.isAllSelected() ? Location.ALL : new Location((Party)this.getSelectedItem());
    }

    public void setSelected(Location location) {
        IMObjectListModel model = this.getModel();
        if (location == null || location.isAll() && model.getAllIndex() == -1 || location.isNone() && model.getNoneIndex() == -1) {
            this.setSelectedItem(null);
        } else if (location.isAll()) {
            this.setSelectedIndex(model.getAllIndex());
        } else if (location.isNone()) {
            this.setSelectedIndex(model.getNoneIndex());
        } else {
            this.setSelectedItem(location.getPracticeLocation());
        }
    }

    public IMObjectListModel getModel() {
        return (IMObjectListModel)super.getModel();
    }

    public List<Party> getLocations() {
        ArrayList<Party> result = new ArrayList<Party>();
        for (IMObject object : this.getModel().getObjects()) {
            if (!(object instanceof Party)) continue;
            result.add((Party)object);
        }
        return result;
    }

    private void initialise() {
        ComponentFactory.setDefaultStyle((Component)this);
        this.setCellRenderer(IMObjectListCellRenderer.NAME);
        if (this.getModel().size() != 0) {
            this.setSelectedIndex(0);
        }
    }

    private static ListModel createModel(Party practice) {
        List<Party> locations = LocationSelectField.getLocations(practice);
        return new IMObjectListModel((List<? extends IMObject>)locations, true, true);
    }

    private static ListModel createModel(User user, Party practice, boolean all, boolean none) {
        List locations = Collections.emptyList();
        if (user != null && practice != null) {
            UserRules rules = ServiceHelper.getBean(UserRules.class);
            locations = rules.getLocations(user, practice);
            if (!locations.isEmpty()) {
                LocationSelectField.sort(locations);
            }
        } else if (practice != null) {
            locations = LocationSelectField.getLocations(practice);
        }
        return new IMObjectListModel(locations, all, none);
    }

    private static List<Party> getLocations(Party practice) {
        List<Object> locations;
        if (practice != null) {
            locations = ServiceHelper.getBean(PracticeRules.class).getLocations(practice);
            LocationSelectField.sort(locations);
        } else {
            locations = new ArrayList<Party>();
        }
        return locations;
    }

    private static void sort(List<Party> locations) {
        IMObjectSorter.sort(locations, "name");
    }
}

