/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.list;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.list.AllNoneListModel;
import org.openvpms.web.system.ServiceHelper;

public class ShortNameListModel
extends AllNoneListModel {
    private String[] shortNames;
    private String[][] shortNameMap;

    public ShortNameListModel(String[] shortNames) {
        this(shortNames, false);
    }

    public ShortNameListModel(String[] shortNames, boolean all) {
        this(shortNames, all, true);
    }

    public ShortNameListModel(List<String> shortNames, boolean all) {
        this(shortNames, all, true);
    }

    public ShortNameListModel(List<String> shortNames, boolean all, boolean sort) {
        this(shortNames, all, false, sort);
    }

    public ShortNameListModel(List<String> shortNames, boolean all, boolean none, boolean sort) {
        this(shortNames.toArray(new String[0]), all, none, sort);
    }

    public ShortNameListModel(String[] shortNames, boolean all, boolean sort) {
        this(shortNames, all, false, sort);
    }

    public ShortNameListModel(String[] shortNames, boolean all, boolean none, boolean sort) {
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        String[][] map = new String[shortNames.length][2];
        for (int i = 0; i < shortNames.length; ++i) {
            String shortName;
            map[i][0] = shortName = shortNames[i];
            String displayName = DescriptorHelper.getDisplayName((String)shortName, (ArchetypeService)service);
            if (StringUtils.isEmpty((CharSequence)displayName)) {
                displayName = shortName;
            }
            map[i][1] = displayName;
        }
        this.setArchetypes(map, all, none, sort);
    }

    public void add(String archetype, String displayName, boolean sort) {
        String[][] map = new String[this.shortNames.length + 1][2];
        boolean all = this.getAllIndex() != -1;
        boolean none = this.getNoneIndex() != -1;
        int index = 0;
        if (all) {
            ++index;
        }
        if (none) {
            ++index;
        }
        System.arraycopy(this.shortNameMap, index, map, 0, this.shortNames.length);
        map[this.shortNames.length][0] = archetype;
        map[this.shortNames.length][1] = displayName;
        this.setArchetypes(map, all, none, sort);
    }

    public Object get(int index) {
        return this.getShortName(index);
    }

    public int size() {
        return this.shortNameMap.length;
    }

    public String getShortName(int index) {
        return this.shortNameMap[index][0];
    }

    public String getDisplayName(int index) {
        return this.shortNameMap[index][1];
    }

    public String[] getShortNames() {
        return this.shortNames;
    }

    public int indexOf(String shortName) {
        int result = -1;
        for (int i = 0; i < this.shortNameMap.length; ++i) {
            if (!this.shortNameMap[i][0].equals(shortName)) continue;
            result = i;
            break;
        }
        return result;
    }

    private void setArchetypes(String[][] map, boolean all, boolean none, boolean sort) {
        if (sort) {
            Arrays.sort(map, Comparator.comparing(o -> o[1]));
        }
        int size = map.length;
        this.shortNames = new String[size];
        for (int i = 0; i < this.shortNames.length; ++i) {
            this.shortNames[i] = map[i][0];
        }
        int index = 0;
        if (all) {
            ++size;
        }
        if (none) {
            ++size;
        }
        this.shortNameMap = new String[size][2];
        if (all) {
            this.setAll(index++);
        }
        if (none) {
            this.setNone(index++);
        }
        System.arraycopy(map, 0, this.shortNameMap, index, map.length);
    }
}

