/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.layout.GridLayoutData;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;

public class ComponentGrid {
    private List<List<Cell>> cells = new ArrayList<List<Cell>>();
    private int columns;
    private ArrayList<Extent> columnWidths = new ArrayList();
    private static final Cell SPAN = new Cell();

    public void add(Component ... components) {
        ArrayList<Cell> row = new ArrayList<Cell>();
        for (Component component : components) {
            row.add(new Cell(component));
        }
        this.addRow(row);
    }

    public void arrange(int columns, Component ... components) {
        for (int i = 0; i < components.length; i += columns) {
            Component[] row = Arrays.copyOfRange(components, i, Math.min(components.length, i + columns));
            this.add(row);
        }
    }

    public void add(int row, Component ... components) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        for (Component component : components) {
            cells.add(new Cell(component));
        }
        this.addRow(row, cells);
    }

    public void add(Component component, int columnSpan) {
        this.set(this.cells.size(), 0, columnSpan, component);
    }

    public void add(ComponentState state, int columnGroupSpan) {
        ComponentState[] states = new ComponentState[]{state};
        this.add(states, 1, columnGroupSpan);
    }

    public void add(ComponentState ... states) {
        ArrayList<Cell> row = new ArrayList<Cell>();
        for (ComponentState state : states) {
            if (state.hasLabel()) {
                row.add(new Cell((Component)this.getLabel(state)));
                row.add(new Cell(state.getComponent(), state));
                continue;
            }
            row.add(new Cell(state.getComponent(), state));
            row.add(null);
        }
        this.addRow(row);
    }

    public void add(ComponentSet set) {
        int columnGroups = set.getComponents().size() <= 2 ? 1 : 2;
        this.add(set, columnGroups);
    }

    public void add(ComponentSet set, int columnGroups) {
        this.add(set, columnGroups, 0);
    }

    public void add(ComponentSet set, int columnGroups, int columnGroupSpan) {
        ComponentState[] states = set.getComponents().toArray(new ComponentState[0]);
        this.add(states, columnGroups, columnGroupSpan);
    }

    public void set(int row, int column, Component component) {
        this.set(row, column, 1, component);
    }

    public void set(int row, int column, int columnSpan, Component component) {
        this.set(row, column, 1, columnSpan, component);
    }

    public void set(int row, int column, int rowSpan, int columnSpan, Component component) {
        GridLayoutData layout = (GridLayoutData)component.getLayoutData();
        if (layout == null) {
            layout = ComponentGrid.layout(rowSpan, columnSpan);
        } else {
            layout.setRowSpan(rowSpan);
            layout.setColumnSpan(columnSpan);
        }
        this.set(row, column, layout, component);
    }

    public void set(int row, int column, GridLayoutData layoutData, Component component) {
        int rowSpan = 1;
        int columnSpan = 1;
        if (layoutData != null) {
            rowSpan = layoutData.getRowSpan();
            columnSpan = layoutData.getColumnSpan();
        }
        for (int i = row; i < row + rowSpan; ++i) {
            for (int j = column; j < column + columnSpan; ++j) {
                this.set(i, j, SPAN);
            }
        }
        this.set(row, column, new Cell(component, null, layoutData));
    }

    public void set(int row, int column, ComponentState state) {
        this.set(row, column, 0, state);
    }

    public void set(int row, int column, int columnGroupSpan, ComponentState state) {
        int span = 2 * columnGroupSpan;
        if (state.hasLabel()) {
            this.set(row, column++, new Cell((Component)this.getLabel(state)));
            if (span > 0) {
                --span;
            }
        }
        this.set(row, column++, new Cell(state.getComponent(), state, ComponentGrid.layout(1, span)));
        for (int i = 0; i < span - 1; ++i) {
            this.set(row, column + i, SPAN);
        }
    }

    public void setColumnWidth(int column, Extent width) {
        while (column >= this.columnWidths.size()) {
            this.columnWidths.add(null);
        }
        this.columnWidths.set(column, width);
    }

    public int getColumns() {
        return this.columns;
    }

    public int getColumns(int row) {
        return row < this.cells.size() ? this.cells.get(row).size() : 0;
    }

    public int getRows() {
        return this.cells.size();
    }

    public Grid createGrid(ComponentSet set) {
        Grid grid = this.createGrid();
        int rows = this.cells.size();
        for (int col = 0; col < this.columns; ++col) {
            for (int row = 0; row < rows; ++row) {
                Cell cell = this.getCell(row, col);
                if (cell == null || cell.getComponentState() == null) continue;
                set.setFocusTraversal(cell.getComponentState());
            }
        }
        return grid;
    }

    public Grid createGrid() {
        Grid grid = GridFactory.create((int)this.columns);
        for (int i = 0; i < this.columnWidths.size(); ++i) {
            grid.setColumnWidth(i, this.columnWidths.get(i));
        }
        int rows = this.cells.size();
        for (int row = 0; row < rows; ++row) {
            int col = 0;
            while (col < this.columns) {
                Cell cell = this.getCell(row, col);
                if (cell != null && cell.getComponent() != null) {
                    Component component = cell.getComponent();
                    if (component instanceof SelectField) {
                        component = RowFactory.create((Component[])new Component[]{component});
                    } else if (component instanceof CheckBox) {
                        component = RowFactory.create((Component[])new Component[]{component});
                    }
                    int columnSpan = cell.getColumnSpan();
                    if (columnSpan <= 1) {
                        columnSpan = 1;
                    }
                    component.setLayoutData((LayoutData)cell.getLayoutData());
                    grid.add(component);
                    col += columnSpan;
                    continue;
                }
                if (cell != SPAN) {
                    grid.add((Component)LabelFactory.create());
                    ++col;
                    continue;
                }
                ++col;
            }
        }
        return grid;
    }

    public static GridLayoutData layout(int rowSpan, int columnSpan) {
        return ComponentGrid.layout(rowSpan, columnSpan, null);
    }

    public static GridLayoutData layout(int rowSpan, int columnSpan, Alignment alignment) {
        GridLayoutData layoutData = new GridLayoutData();
        layoutData.setRowSpan(rowSpan);
        layoutData.setColumnSpan(columnSpan);
        layoutData.setAlignment(alignment);
        return layoutData;
    }

    public static GridLayoutData layout(Alignment alignment) {
        GridLayoutData layoutData = new GridLayoutData();
        layoutData.setAlignment(alignment);
        return layoutData;
    }

    protected void add(ComponentState[] states, int columnGroups, int columnGroupSpan) {
        int size = states.length;
        int rows = columnGroups == 1 ? size : size / 2 + size % 2;
        this.add(states, columnGroups, rows, columnGroupSpan);
    }

    protected void add(ComponentState[] states, int columns, int rows, int columnGroupSpan) {
        int index = 0;
        int start = this.cells.size();
        int end = start + rows;
        for (int col = 0; col < columns; ++col) {
            for (int row = start; row < end && index < states.length; ++row) {
                this.set(row, col * 2, columnGroupSpan, states[index++]);
            }
        }
    }

    private Label getLabel(ComponentState state) {
        Label label = state.getLabel();
        if (label != null && (label.getStyleName() == null || "default".equals(label.getStyleName()))) {
            label.setStyleName("default.grid");
        }
        return label;
    }

    private void set(int row, int column, Cell cell) {
        List<Cell> cells = this.grow(row, column);
        cells.set(column, cell);
    }

    private List<Cell> grow(int row, int column) {
        while (row >= this.cells.size()) {
            this.cells.add(new ArrayList());
        }
        List<Cell> list = this.cells.get(row);
        while (column >= list.size()) {
            list.add(null);
        }
        if (column >= this.columns) {
            this.columns = column + 1;
        }
        return list;
    }

    private void addRow(List<Cell> row) {
        this.cells.add(row);
        this.checkMaxColumns(row);
    }

    private void addRow(int index, List<Cell> row) {
        this.cells.add(index, row);
        this.checkMaxColumns(row);
    }

    private void checkMaxColumns(List<Cell> row) {
        if (this.columns < row.size()) {
            this.columns = row.size();
        }
    }

    private Cell getCell(int row, int column) {
        List<Cell> list = this.cells.get(row);
        return column < list.size() ? list.get(column) : null;
    }

    private static class Cell {
        private final Component component;
        private final ComponentState state;
        private final GridLayoutData layoutData;

        Cell() {
            this(null);
        }

        Cell(Component component) {
            this(component, null);
        }

        Cell(Component component, ComponentState state) {
            this(component, state, component != null && component.getLayoutData() instanceof GridLayoutData ? (GridLayoutData)component.getLayoutData() : null);
        }

        Cell(Component component, ComponentState state, GridLayoutData layoutData) {
            this.component = component;
            this.state = state;
            this.layoutData = layoutData;
        }

        int getColumnSpan() {
            return this.layoutData != null ? this.layoutData.getColumnSpan() : 1;
        }

        Component getComponent() {
            return this.component;
        }

        ComponentState getComponentState() {
            return this.state;
        }

        GridLayoutData getLayoutData() {
            return this.layoutData;
        }
    }
}

