/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.web.component.im.filter.NodeFilter;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;

public class ArchetypeNodes {
    private String first;
    private String second;
    private boolean allSimpleNodes;
    private boolean allComplexNodes;
    private Set<String> list = new LinkedHashSet<String>();
    private Set<String> includeSimpleNodes = new LinkedHashSet<String>();
    private Set<String> includeComplexNodes = new LinkedHashSet<String>();
    private Set<String> exclude = new HashSet<String>();
    private Set<String> excludeIfEmpty = new HashSet<String>();
    private long excludeStringLongerThan = -1L;
    private boolean excludePassword = false;
    private boolean hidden;
    private List<String> order = new ArrayList<String>();

    public ArchetypeNodes() {
        this(true, true);
    }

    public ArchetypeNodes(boolean includeAllSimple, boolean includeAllComplex) {
        this.allSimpleNodes = includeAllSimple;
        this.allComplexNodes = includeAllComplex;
    }

    public ArchetypeNodes(ArchetypeNodes nodes) {
        this.allSimpleNodes = nodes.allSimpleNodes;
        this.allComplexNodes = nodes.allSimpleNodes;
        this.first = nodes.first;
        this.second = nodes.second;
        this.list = new LinkedHashSet<String>(nodes.list);
        this.includeSimpleNodes = new LinkedHashSet<String>(nodes.includeSimpleNodes);
        this.includeComplexNodes = new LinkedHashSet<String>(nodes.includeComplexNodes);
        this.exclude = new HashSet<String>(nodes.exclude);
        this.excludeIfEmpty = new HashSet<String>(nodes.excludeIfEmpty);
        this.excludeStringLongerThan = nodes.excludeStringLongerThan;
        this.hidden = nodes.hidden;
        this.excludePassword = nodes.excludePassword;
        this.order = new ArrayList<String>(nodes.order);
    }

    public ArchetypeNodes first(String first) {
        this.first = first;
        return this;
    }

    public ArchetypeNodes second(String second) {
        this.second = second;
        return this;
    }

    public ArchetypeNodes list(String ... nodes) {
        this.list.addAll(Arrays.asList(nodes));
        return this;
    }

    public ArchetypeNodes simple(String ... nodes) {
        this.includeSimpleNodes.addAll(Arrays.asList(nodes));
        return this;
    }

    public ArchetypeNodes complex(String ... nodes) {
        this.includeComplexNodes.addAll(Arrays.asList(nodes));
        return this;
    }

    public ArchetypeNodes exclude(String ... nodes) {
        return this.exclude(Arrays.asList(nodes));
    }

    public ArchetypeNodes exclude(Collection<String> nodes) {
        this.exclude.addAll(nodes);
        return this;
    }

    public ArchetypeNodes excludeIfEmpty(String ... nodes) {
        Collections.addAll(this.excludeIfEmpty, nodes);
        return this;
    }

    public ArchetypeNodes excludeStringLongerThan(long length) {
        this.excludeStringLongerThan = length;
        return this;
    }

    public ArchetypeNodes hidden(boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public ArchetypeNodes excludePassword(boolean exclude) {
        this.excludePassword = exclude;
        return this;
    }

    public ArchetypeNodes order(String node1, String node2) {
        this.order.add(node1);
        this.order.add(node2);
        return this;
    }

    public List<String> getNodeNames(List<org.openvpms.component.model.archetype.ArchetypeDescriptor> archetypes) {
        List<NodeDescriptor> result = new ArrayList<NodeDescriptor>();
        All all = new All();
        for (org.openvpms.component.model.archetype.ArchetypeDescriptor archetype : archetypes) {
            List<NodeDescriptor> nodes = this.getNodes(archetype, all);
            if (result.isEmpty()) {
                result = nodes;
                continue;
            }
            result = this.merge(result, nodes);
        }
        return this.getNames(this.reorder(result));
    }

    public List<NodeDescriptor> getSimpleNodes(org.openvpms.component.model.archetype.ArchetypeDescriptor archetype) {
        return this.getNodes(archetype, new SimplePredicate());
    }

    public List<NodeDescriptor> getSimpleNodes(org.openvpms.component.model.archetype.ArchetypeDescriptor archetype, org.openvpms.component.model.object.IMObject object, NodeFilter filter) {
        return this.getNodes(archetype, object, this.includeSimpleNodes, new SimplePredicate(object), filter);
    }

    public List<Property> getSimpleNodes(PropertySet properties, org.openvpms.component.model.archetype.ArchetypeDescriptor archetype, org.openvpms.component.model.object.IMObject object, NodeFilter filter) {
        ArrayList<Property> result = new ArrayList<Property>();
        for (NodeDescriptor descriptor : this.getSimpleNodes(archetype, object, filter)) {
            Property property = properties.get(descriptor.getName());
            if (property == null) continue;
            result.add(property);
        }
        return result;
    }

    public List<NodeDescriptor> getComplexNodes(org.openvpms.component.model.archetype.ArchetypeDescriptor archetype) {
        return this.getNodes(archetype, new ComplexPredicate());
    }

    public List<NodeDescriptor> getComplexNodes(org.openvpms.component.model.archetype.ArchetypeDescriptor archetype, org.openvpms.component.model.object.IMObject object, NodeFilter filter) {
        return this.getNodes(archetype, object, this.includeComplexNodes, new ComplexPredicate(object), filter);
    }

    public List<Property> getComplexNodes(PropertySet properties, org.openvpms.component.model.archetype.ArchetypeDescriptor archetype, org.openvpms.component.model.object.IMObject object, NodeFilter filter) {
        ArrayList<Property> result = new ArrayList<Property>();
        for (NodeDescriptor descriptor : this.getComplexNodes(archetype, object, filter)) {
            result.add(properties.get(descriptor.getName()));
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ArchetypeNodes) {
            ArchetypeNodes nodes = (ArchetypeNodes)other;
            return Objects.equals(this.first, nodes.first) && Objects.equals(this.second, nodes.second) && this.allSimpleNodes == nodes.allSimpleNodes && this.allComplexNodes == nodes.allComplexNodes && this.includeSimpleNodes.equals(nodes.includeSimpleNodes) && this.includeComplexNodes.equals(nodes.includeComplexNodes) && this.exclude.equals(nodes.exclude) && this.excludeIfEmpty.equals(nodes.excludeIfEmpty) && this.excludeStringLongerThan == nodes.excludeStringLongerThan && this.hidden == nodes.hidden && this.excludePassword == nodes.excludePassword;
        }
        return false;
    }

    public static ArchetypeNodes all() {
        return new ArchetypeNodes();
    }

    public static ArchetypeNodes onlySimple(String ... nodes) {
        return new ArchetypeNodes(false, false).simple(nodes);
    }

    public static ArchetypeNodes allSimple() {
        return new ArchetypeNodes(true, false);
    }

    public static ArchetypeNodes allComplex() {
        return new ArchetypeNodes(false, true);
    }

    public static ArchetypeNodes none() {
        return new ArchetypeNodes(false, false);
    }

    public static ArchetypeNodes nodes(String ... nodes) {
        return ArchetypeNodes.none().list(nodes);
    }

    public static Property find(List<Property> properties, String name) {
        for (Property property : properties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public static Property remove(List<Property> properties, String name) {
        Iterator<Property> iterator = properties.iterator();
        while (iterator.hasNext()) {
            Property property = iterator.next();
            if (!property.getName().equals(name)) continue;
            iterator.remove();
            return property;
        }
        return null;
    }

    public static List<Property> removeAll(List<Property> properties, String ... names) {
        ArrayList<Property> result = new ArrayList<Property>();
        ArrayList<String> keys = new ArrayList<String>(Arrays.asList(names));
        Iterator<Property> iterator = properties.iterator();
        while (iterator.hasNext()) {
            Property property = iterator.next();
            String name = property.getName();
            if (!keys.remove(name)) continue;
            result.add(property);
            iterator.remove();
            if (!keys.isEmpty()) continue;
            break;
        }
        return result;
    }

    public static List<Property> include(List<Property> properties, String ... names) {
        ArrayList<Property> result = new ArrayList<Property>();
        List<String> values = Arrays.asList(names);
        for (Property property : properties) {
            if (!values.contains(property.getName())) continue;
            result.add(property);
        }
        return result;
    }

    public static List<Property> insertBefore(List<Property> list, String before, Property ... properties) {
        int i;
        for (i = 0; i < list.size() && !before.equals(list.get(i).getName()); ++i) {
        }
        list.addAll(i, Arrays.asList(properties));
        return list;
    }

    public static List<Property> insertAfter(List<Property> list, String after, Property ... properties) {
        int i;
        for (i = 0; i < list.size(); ++i) {
            if (!after.equals(list.get(i).getName())) continue;
            ++i;
            break;
        }
        list.addAll(i, Arrays.asList(properties));
        return list;
    }

    public static List<Property> exclude(List<Property> properties, String ... names) {
        ArrayList<Property> result = new ArrayList<Property>(properties);
        List<String> values = Arrays.asList(names);
        for (Property property : properties) {
            if (!values.contains(property.getName())) continue;
            result.remove(property);
        }
        return result;
    }

    private List<NodeDescriptor> merge(List<NodeDescriptor> first, List<NodeDescriptor> second) {
        String name;
        ArrayList<NodeDescriptor> result = new ArrayList<NodeDescriptor>();
        ArrayList<NodeDescriptor> left = new ArrayList<NodeDescriptor>(second);
        for (NodeDescriptor node : first) {
            int index;
            name = node.getName();
            if (this.indexOf(name, second) != -1 || this.includeSimpleNodes.contains(name) || this.includeComplexNodes.contains(name) || this.list.contains(name)) {
                result.add(node);
            }
            if ((index = this.indexOf(name, left)) == -1) continue;
            left.remove(index);
        }
        for (NodeDescriptor node : left) {
            NodeDescriptor prior;
            int pos;
            name = node.getName();
            if (!this.includeSimpleNodes.contains(name) && !this.includeComplexNodes.contains(name) && !this.list.contains(name)) continue;
            boolean found = false;
            int index = this.indexOf(name, second) - 1;
            if (index > 0 && (pos = this.indexOf((prior = second.get(index)).getName(), result)) != -1) {
                result.add(pos + 1, node);
                found = true;
            }
            if (found) continue;
            result.add(0, node);
        }
        return result;
    }

    private List<String> getNames(List<NodeDescriptor> descriptors) {
        ArrayList<String> result = new ArrayList<String>();
        for (NodeDescriptor descriptor : descriptors) {
            result.add(descriptor.getName());
        }
        return result;
    }

    private List<NodeDescriptor> getNodes(org.openvpms.component.model.archetype.ArchetypeDescriptor archetype, Predicate predicate) {
        ArrayList<NodeDescriptor> result = new ArrayList<NodeDescriptor>();
        ArchetypeDescriptor desc = (ArchetypeDescriptor)archetype;
        List nodes = desc.getAllNodeDescriptors();
        CollectionUtils.select((Iterable)nodes, (Predicate)predicate, result);
        this.reorder(result);
        return result;
    }

    private List<NodeDescriptor> getNodes(org.openvpms.component.model.archetype.ArchetypeDescriptor archetype, org.openvpms.component.model.object.IMObject object, Set<String> includes, Predicate predicate, NodeFilter filter) {
        List<NodeDescriptor> result;
        List<NodeDescriptor> nodes = this.getNodes(archetype, predicate);
        if (filter != null) {
            result = new ArrayList<NodeDescriptor>();
            for (NodeDescriptor node : nodes) {
                if (!includes.contains(node.getName()) && !filter.include(node, object)) continue;
                result.add(node);
            }
        } else {
            result = nodes;
        }
        return result;
    }

    private List<NodeDescriptor> reorder(List<NodeDescriptor> descriptors) {
        int i = 0;
        for (String node : this.list) {
            int index = this.indexOf(node, descriptors);
            if (index == -1) continue;
            this.move(index, i, descriptors);
            ++i;
        }
        if (this.first != null) {
            this.move(this.first, 0, descriptors);
        }
        if (this.second != null) {
            this.move(this.second, 1, descriptors);
        }
        for (int j = 0; j < this.order.size(); j += 2) {
            String node1 = this.order.get(j);
            String node2 = this.order.get(j + 1);
            int index = this.indexOf(node2, descriptors);
            if (index == -1) continue;
            this.move(node1, index, descriptors);
        }
        return descriptors;
    }

    private int indexOf(String node, List<NodeDescriptor> descriptors) {
        for (int i = 0; i < descriptors.size(); ++i) {
            NodeDescriptor descriptor = descriptors.get(i);
            if (!descriptor.getName().equals(node)) continue;
            return i;
        }
        return -1;
    }

    private void move(String node, int index, List<NodeDescriptor> descriptors) {
        int pos = this.indexOf(node, descriptors);
        if (pos != -1) {
            this.move(pos, index, descriptors);
        }
    }

    private void move(int oldIndex, int newIndex, List<NodeDescriptor> descriptors) {
        if (oldIndex != newIndex) {
            NodeDescriptor descriptor = descriptors.remove(oldIndex);
            if (oldIndex > newIndex) {
                descriptors.add(newIndex, descriptor);
            } else {
                descriptors.add(newIndex - 1, descriptor);
            }
        }
    }

    private boolean isEmpty(org.openvpms.component.model.object.IMObject object, NodeDescriptor descriptor) {
        Object value = descriptor.getValue((org.openvpms.component.model.object.IMObject)((IMObject)object));
        boolean result = value instanceof String ? ((String)value).length() == 0 : (value instanceof Collection ? ((Collection)value).isEmpty() : value == null);
        return result;
    }

    private class All
    extends AbstractPredicate {
        private SimplePredicate simple;
        private ComplexPredicate complex;

        private All() {
            this.simple = new SimplePredicate();
            this.complex = new ComplexPredicate();
        }

        public boolean evaluate(NodeDescriptor object) {
            return this.simple.evaluate(object) || this.complex.evaluate(object);
        }
    }

    private class ComplexPredicate
    extends AbstractPredicate {
        public ComplexPredicate() {
        }

        public ComplexPredicate(org.openvpms.component.model.object.IMObject object) {
            super(object);
        }

        public boolean evaluate(NodeDescriptor descriptor) {
            boolean named;
            boolean include = false;
            String name = descriptor.getName();
            boolean complex = descriptor.isComplexNode();
            boolean listed = ArchetypeNodes.this.list.contains(name);
            boolean includeComplex = ArchetypeNodes.this.includeComplexNodes.contains(name);
            boolean bl = named = includeComplex || listed;
            if ((ArchetypeNodes.this.allComplexNodes && complex || named) && !ArchetypeNodes.this.includeSimpleNodes.contains(name)) {
                boolean excludeSimple = listed && !includeComplex && !complex;
                include = !excludeSimple && this.include(descriptor, named);
            }
            return include;
        }
    }

    private class SimplePredicate
    extends AbstractPredicate {
        public SimplePredicate() {
        }

        public SimplePredicate(org.openvpms.component.model.object.IMObject object) {
            super(object);
        }

        public boolean evaluate(NodeDescriptor descriptor) {
            boolean named;
            boolean include = false;
            String name = descriptor.getName();
            boolean simple = !descriptor.isComplexNode();
            boolean listed = ArchetypeNodes.this.list.contains(name);
            boolean includeSimple = ArchetypeNodes.this.includeSimpleNodes.contains(name);
            boolean bl = named = includeSimple || listed;
            if ((ArchetypeNodes.this.allSimpleNodes && simple || named) && !ArchetypeNodes.this.includeComplexNodes.contains(name)) {
                boolean excludeComplex = listed && !includeSimple && !simple;
                include = !excludeComplex && this.include(descriptor, named);
            }
            return include;
        }
    }

    private abstract class AbstractPredicate
    implements Predicate<NodeDescriptor> {
        private final org.openvpms.component.model.object.IMObject object;

        public AbstractPredicate() {
            this(null);
        }

        public AbstractPredicate(org.openvpms.component.model.object.IMObject object) {
            this.object = object;
        }

        protected boolean include(NodeDescriptor descriptor, boolean ignoreHidden) {
            boolean result = false;
            String name = descriptor.getName();
            if ((ArchetypeNodes.this.hidden || ignoreHidden || !descriptor.isHidden()) && !ArchetypeNodes.this.exclude.contains(name)) {
                result = !(this.excludeIfEmpty(descriptor) || descriptor.isString() && !this.includeString(descriptor) || ArchetypeNodes.this.excludePassword && descriptor.containsAssertionType("password"));
            }
            return result;
        }

        private boolean excludeIfEmpty(NodeDescriptor descriptor) {
            return this.object != null && ArchetypeNodes.this.excludeIfEmpty.contains(descriptor.getName()) && ArchetypeNodes.this.isEmpty(this.object, descriptor);
        }

        private boolean includeString(NodeDescriptor descriptor) {
            return ArchetypeNodes.this.excludeStringLongerThan == -1L || (long)descriptor.getMaxLength() <= ArchetypeNodes.this.excludeStringLongerThan;
        }
    }
}

