/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit.reminder;

import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.PropertySet;

public class ReminderLayoutStrategy
extends AbstractLayoutStrategy {
    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        IMObjectBean bean;
        boolean showProduct = parent instanceof Act ? !(bean = this.getBean(parent)).hasNode("product") : true;
        ArchetypeNodes nodes = ArchetypeNodes.all();
        if (!showProduct) {
            nodes.exclude("product");
        }
        this.setArchetypeNodes(nodes);
        if (context.isEdit()) {
            int reminderCount = properties.get("reminderCount").getInt();
            if (reminderCount != 0) {
                this.addComponent(this.createComponent(this.createReadOnly(properties.get("reminderType")), object, context));
                this.addComponent(this.createComponent(this.createReadOnly(properties.get("endTime")), object, context));
            } else {
                this.addComponent(this.createComponent(this.createReadOnly(properties.get("startTime")), object, context));
            }
            CollectionProperty items = (CollectionProperty)properties.get("items");
            if (items.getValues().isEmpty() && !UserHelper.isAdmin(context.getContext().getUser())) {
                nodes.exclude("items");
            }
        } else {
            nodes.excludeIfEmpty("items");
        }
        return super.apply(object, properties, parent, context);
    }
}

